package ru.yandex.autotests.directapi.model.api5.sitelinks;

import com.yandex.direct.api.v5.sitelinks.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by semkagtn on 10/7/14.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final int MAX_SITELINKS_SETS_AMOUNT = 1000;

    public static final String SITELINKS_SETS = "sitelinksSets";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withSitelinksSets(SitelinksSetAddItemMap... sitelinks) {
        this.put(SITELINKS_SETS, (sitelinks == null) ? null : convert(sitelinks, new BeanMapToBeanConverter()));
        return this;
    }
}
