package ru.yandex.autotests.directapi.model.api5.sitelinks;

import com.yandex.direct.api.v5.sitelinks.DeleteRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by semkagtn on 10/7/14.
 */
public class DeleteRequestMap extends ModelBeanMap<DeleteRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public DeleteRequestMap() {
        super();
        setBean(new DeleteRequest());
    }

    public DeleteRequestMap(DeleteRequest deleteRequest) {
        super();
        setBean(deleteRequest);
    }

    public DeleteRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeleteRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
