package ru.yandex.autotests.directapi.model.api5.sitelinks;

import java.util.Arrays;

import com.yandex.direct.api.v5.sitelinks.GetRequest;
import com.yandex.direct.api.v5.sitelinks.SitelinkFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by semkagtn on 10/7/14.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String SITELINK_FIELD_NAMES = "sitelinkFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(SitelinksSetFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withSitelinkFieldNames(SitelinkFieldEnum... fieldNames) {
        this.put(SITELINK_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }
}
