package ru.yandex.autotests.directapi.model.api5.sitelinks;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.yandex.direct.api.v5.sitelinks.SitelinkGetItem;
import org.apache.commons.lang3.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10/7/14.
 */
public class SitelinkGetMap extends ModelBeanMap<SitelinkGetMap> {

    public static final int MAX_TITLE_LENGTH = 30;
    public static final int MAX_SUM_TITLE_LENGTH = 66;
    public static final int MAX_HREF_LENGTH = 1024;
    public static final int MIN_DOMAIN_LENGTH = 1;
    public static final int MAX_DOMAIN_LENGTH = 63;
    public static final int MIN_TOP_DOMAIN_LENGTH = 2;
    public static final int MAX_TOP_DOMAIN_LENGTH = 15;
    public static final int MAX_DESCRIPTION_LENGTH = 60;
    public static final int URL_PATH_LENGTH = 60;

    public static final String TITLE = "title";
    public static final String HREF = "href";
    public static final String DESCRIPTION = "description";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public SitelinkGetMap() {
        super();
        setBean(new SitelinkGetItem());
    }

    public SitelinkGetMap(SitelinkGetItem sitelink) {
        super();
        setBean(sitelink);
    }

    public SitelinkGetMap randomSitelinkWithDescription() {
        return randomSitelink().withRandomDescription();
    }

    public SitelinkGetMap randomSitelink() {
        return withRandomTitle().withRandomHref();
    }

    public SitelinkGetMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public SitelinkGetMap withHref(String href) {
        this.put(HREF, jaxbElement(String.class, href));
        return this;
    }


    public SitelinkGetMap withDescription(String description) {
        this.put(DESCRIPTION, jaxbElement(String.class, description));
        return this;
    }

    public SitelinkGetMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, jaxbElement(Long.class, turboPageId));
        return this;
    }

    public SitelinkGetMap withoutTurboPageId() {
        this.put(TURBO_PAGE_ID, null);
        return this;
    }

    public SitelinkGetMap withRandomHref() {
        return this.withHref("http://ya.ru/" + RandomStringUtils.randomAlphabetic(URL_PATH_LENGTH));
    }

    public SitelinkGetMap withRandomTitle(int length) {
        this.put(TITLE, RandomStringUtils.randomAlphabetic(length));
        return this;
    }

    public SitelinkGetMap withRandomTitle() {
        this.put(TITLE, RandomStringUtils.randomAlphabetic(
                MAX_SUM_TITLE_LENGTH / (SitelinksSetAddItemMap.MAX_SITELINKS_AMOUNT + 1)));
        return this;
    }

    public SitelinkGetMap withRandomDescription() {
        this.put(DESCRIPTION, RandomStringUtils.randomAlphabetic(MAX_DESCRIPTION_LENGTH / 2));
        return this;
    }

    private JAXBElement jaxbElement(Class className, Object value) {
        return new JAXBElement(new QName("Name"), className, value);
    }
}
