package ru.yandex.autotests.directapi.model.api5.sitelinks;

import com.yandex.direct.api.v5.sitelinks.SitelinkAddItem;
import org.apache.commons.lang3.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10/7/14.
 */
public class SitelinkMap extends ModelBeanMap<SitelinkMap> {

    public static final int MAX_TITLE_LENGTH = 30;
    public static final int MAX_SUM_TITLE_LENGTH = 66;
    public static final int MAX_HREF_LENGTH = 1024;
    public static final int MIN_DOMAIN_LENGTH = 1;
    public static final int MAX_DOMAIN_LENGTH = 63;
    public static final int MIN_TOP_DOMAIN_LENGTH = 2;
    public static final int MAX_TOP_DOMAIN_LENGTH = 15;
    public static final int MAX_DESCRIPTION_LENGTH = 60;
    public static final int URL_PATH_LENGTH = 60;

    public static final String TITLE = "title";
    public static final String HREF = "href";
    public static final String DESCRIPTION = "description";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public SitelinkMap() {
        super();
        setBean(new SitelinkAddItem());
    }

    public SitelinkMap(SitelinkAddItem sitelink) {
        super();
        setBean(sitelink);
    }

    public SitelinkMap randomSitelinkWithDescription() {
        return randomSitelink().withRandomDescription();
    }

    public SitelinkMap randomSitelink() {
        return withRandomTitle().withRandomHref();
    }

    public SitelinkMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public SitelinkMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public SitelinkMap withDescription(String description) {
        this.put(DESCRIPTION, description);
        return this;
    }

    public SitelinkMap withRandomHref() {
        this.put(HREF, "http://ya.ru/" + RandomStringUtils.randomAlphabetic(URL_PATH_LENGTH));
        return this;
    }

    public SitelinkMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, turboPageId);
        return this;
    }

    public SitelinkMap withRandomTitle(int length) {
        this.put(TITLE, RandomStringUtils.randomAlphabetic(length));
        return this;
    }

    public SitelinkMap withRandomTitle() {
        this.put(TITLE, RandomStringUtils.randomAlphabetic(
                MAX_SUM_TITLE_LENGTH / (SitelinksSetAddItemMap.MAX_SITELINKS_AMOUNT + 1)));
        return this;
    }

    public SitelinkMap withRandomDescription() {
        this.put(DESCRIPTION, RandomStringUtils.randomAlphabetic(MAX_DESCRIPTION_LENGTH / 2));
        return this;
    }

    public SitelinkGetMap asSitelinkGetMap() {
        SitelinkGetMap sitelinkGetMap = new SitelinkGetMap()
                .withHref((String) this.get(HREF))
                .withTitle((String) this.get(TITLE))
                .withDescription((String) this.get(DESCRIPTION))
                .withTurboPageId((Long) this.get(TURBO_PAGE_ID));
        return this.get(TURBO_PAGE_ID) == null ? sitelinkGetMap.withoutTurboPageId() : sitelinkGetMap;
    }
}


