package ru.yandex.autotests.directapi.model.api5.sitelinks;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetAddItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by semkagtn on 10/7/14.
 */
public class SitelinksSetAddItemMap extends ModelBeanMap<SitelinksSetAddItemMap> {

    public static final int MIN_SITELINKS_AMOUNT = 1;
    public static final int MAX_SITELINKS_AMOUNT = 8;
    public static final int SITELINKS_PER_BLOCK = 4;

    public static final String SITELINKS = "sitelinks";

    public SitelinksSetAddItemMap() {
        super();
        setBean(new SitelinksSetAddItem());
    }

    public SitelinksSetAddItemMap(SitelinksSetAddItem sitelinksSetAddItem) {
        super();
        setBean(sitelinksSetAddItem);
    }

    public SitelinksSetAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SitelinksSetAddItemMap withSitelinks(SitelinkMap... sitelinks) {
        this.put(SITELINKS, (sitelinks == null) ? null : convert(sitelinks, new BeanMapToBeanConverter()));
        return this;
    }

    public SitelinksSetAddItemMap defaultSitelinksSet(int amount) {
        SitelinkMap[] sitelinks = new SitelinkMap[amount];
        for (int i = 0; i < sitelinks.length; i++) {
            sitelinks[i] = new SitelinkMap().randomSitelink();
        }
        return withSitelinks(sitelinks);
    }

    public SitelinksSetAddItemMap defaultSitelinksSetWithDescriptions(int amount) {
        SitelinkMap[] sitelinks = new SitelinkMap[amount];
        for (int i = 0; i < sitelinks.length; i++) {
            sitelinks[i] = new SitelinkMap().randomSitelinkWithDescription();
        }
        return withSitelinks(sitelinks);
    }
}
