package ru.yandex.autotests.directapi.model.api5.sitelinks;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by semkagtn on 1/30/15.
 */
public class SitelinksSetGetItemMap extends ModelBeanMap<SitelinksSetGetItemMap> {

    public static final String ID = "id";
    public static final String SITELINKS = "sitelinks";

    public SitelinksSetGetItemMap() {
        super();
        setBean(new SitelinksSetGetItem());
    }

    public SitelinksSetGetItemMap(SitelinksSetGetItem SitelinksSetGetItem) {
        super();
        setBean(SitelinksSetGetItem);
    }

    public SitelinksSetGetItemMap withId(Long id) {
        put(ID, id);
        return this;
    }

    public SitelinksSetGetItemMap withSitelinks(SitelinkGetMap... sitelinks) {
        this.put(SITELINKS, (sitelinks == null) ? null : convert(sitelinks, new BeanMapToBeanConverter()));
        return this;
    }
}
