package ru.yandex.autotests.directapi.model.api5.turbopages;

import java.util.Arrays;

import com.yandex.direct.api.v5.turbopages.GetRequest;
import com.yandex.direct.api.v5.turbopages.TurboPageFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by adubinkin on 18/04/19.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(TurboPagesCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(TurboPageFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }
}
