package ru.yandex.autotests.directapi.model.api5.turbopages;

import com.yandex.direct.api.v5.turbopages.TurboPageGetItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by adubinkin on 18/04/19.
 */
public class TurboPageGetItemMap extends ModelBeanMap<TurboPageGetItemMap> {

    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String HREF = "href";
    public static final String PREVIEW_HREF = "previewHref";

    public TurboPageGetItemMap() {
        super();
        setBean(new TurboPageGetItem());
    }

    public TurboPageGetItemMap(TurboPageGetItem turboPageGetItem) {
        super();
        setBean(turboPageGetItem);
    }

    public TurboPageGetItemMap withId(Long id) {
        put(ID, id);
        return this;
    }

    public TurboPageGetItemMap withName(String name) {
        put(NAME, name);
        return this;
    }

    public TurboPageGetItemMap withHref(String href) {
        put(HREF, href);
        return this;
    }

    public TurboPageGetItemMap withPreviewHref(String previewHref) {
        put(PREVIEW_HREF, previewHref);
        return this;
    }
}
