package ru.yandex.autotests.directapi.model.api5.turbopages;

import java.util.Arrays;

import com.yandex.direct.api.v5.turbopages.TurboPagesSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author adubinkin
 * Date 17.11.20
 */
public class TurboPagesCriteriaMap extends ModelBeanMap<TurboPagesCriteriaMap> {

    public static final String IDS = "ids";
    public static final String BOUND_WITH_HREFS = "boundWithHrefs";



    public TurboPagesCriteriaMap() {
        super();
        setBean(new TurboPagesSelectionCriteria());
    }

    public TurboPagesCriteriaMap(TurboPagesSelectionCriteria selectionCriteria) {
        super();
        setBean(selectionCriteria);
    }

    public TurboPagesCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TurboPagesCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public TurboPagesCriteriaMap withBoundWithHrefs(String... hrefs) {
        this.put(BOUND_WITH_HREFS, Arrays.asList(hrefs));
        return this;
    }
}
