package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;


/**
 * Created by chicos on 02.09.14.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String VCARDS = "VCards";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withVCards(VCardAddMap... vCards) {
        this.put(VCARDS, (vCards == null) ? null : convert(vCards, new BeanMapToBeanConverter()));
        return this;
    }
}
