package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.InstantMessenger;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.banners.IMClient;

/**
 * Created by chicos on 09.06.14.
 */
public class InstantMessengerMap extends ModelBeanMap<InstantMessengerMap> {
    public static final String IM_CLIENT = "messengerClient";
    public static final String IM_LOGIN = "messengerLogin";

    public InstantMessengerMap() {
        super();
        setBean(new InstantMessenger());
    }

    public InstantMessengerMap(InstantMessenger im) {
        super();
        setBean(im);
    }

    public InstantMessengerMap defaultInstantMessenger() {
        this.clear();
        this.withIMClient(IMClient.SKYPE)
                .withIMLogin("at-tester");
        return this;
    }

    public InstantMessengerMap withIMClient(String value) {
        this.put(IM_CLIENT, value);
        return this;
    }

    public InstantMessengerMap withIMLogin(String value) {
        this.put(IM_LOGIN, value);
        return this;
    }
}
