package ru.yandex.autotests.directapi.model.api5.vcards;

import java.math.BigDecimal;
import java.math.RoundingMode;

import com.yandex.direct.api.v5.vcards.MapPoint;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 09.06.14.
 */
public class MapPointMap extends ModelBeanMap<MapPointMap> {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String X_1 = "x1";
    public static final String Y_1 = "y1";
    public static final String X_2 = "x2";
    public static final String Y_2 = "y2";

    public MapPointMap() {
        super();
        setBean(new MapPoint());
    }

    public MapPointMap(MapPoint point) {
        super();
        setBean(point);
    }

    public MapPointMap defaultPointOnMap() {
        this.clear();
        this.withX(45.733604f)
                .withY(45.724312f)
                .withX1(27.603738f)
                .withY1(27.587272f)
                .withX2(27.570806f)
                .withY2(45.742894f);
        return this;
    }

    public MapPointMap pointOnMapCentered() {
        this.clear();
        this.withX(59.984075f)
                .withY(30.192606f)
                .withX1(59.984175f)
                .withY1(30.192406f)
                .withX2(59.983975f)
                .withY2(30.192506f);
        return this;
    }


    public MapPointMap point(float x, float y, float x1, float y1, float x2, float y2) {
        withX(x);
        withY(y);
        withX1(x1);
        withY1(y1);
        withX2(x2);
        withY2(y2);
        return this;
    }

    public MapPointMap withX(float value) {
        this.put((X), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY(float value) {
        this.put((Y), new BigDecimal(value));
        return this;
    }

    public MapPointMap withX1(float value) {
        this.put((X_1), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY1(float value) {
        this.put((Y_1), new BigDecimal(value));
        return this;
    }

    public MapPointMap withX2(float value) {
        this.put((X_2), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY2(float value) {
        this.put((Y_2), new BigDecimal(value));
        return this;
    }

    public MapPointMap withX(String value) {
        this.put((X), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY(String value) {
        this.put((Y), new BigDecimal(value));
        return this;
    }

    public MapPointMap withX1(String value) {
        this.put((X_1), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY1(String value) {
        this.put((Y_1), new BigDecimal(value));
        return this;
    }

    public MapPointMap withX2(String value) {
        this.put((X_2), new BigDecimal(value));
        return this;
    }

    public MapPointMap withY2(String value) {
        this.put((Y_2), new BigDecimal(value));
        return this;
    }

    /**
     * Set scale of map point coordinates
     *
     * @param scale
     * @return
     */
    public MapPointMap setPointScale(int scale) {
        Object entry;
        for (Object key : this.keySet()) {
            entry = this.get(key);
            if (entry != null && entry instanceof BigDecimal) {
                this.put(key, ((BigDecimal) entry).setScale(scale, RoundingMode.HALF_UP));
            }
        }
        return this;
    }
}
