package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.Phone;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 09.06.14.
 */
public class PhoneMap extends ModelBeanMap<PhoneMap> {
    public static final String COUNTRY_CODE = "countryCode";
    public static final String CITY_CODE = "cityCode";
    public static final String PHONE_NUMBER = "phoneNumber";
    public static final String EXTENSION = "extension";

    public PhoneMap() {
        super();
        setBean(new Phone());
    }

    public PhoneMap(Phone phone) {
        super();
        setBean(phone);
    }

    public PhoneMap defaultPhone() {
        this.clear();
        this.withCountryCode("+7")
                .withCityCode("812")
                .withPhoneNumber("123-45-67")
                .withExtension("89");
        return this;
    }

    public PhoneMap withCountryCode(String value) {
        this.put(COUNTRY_CODE, value);
        return this;
    }

    public PhoneMap withCityCode(String value) {
        this.put(CITY_CODE, value);
        return this;
    }

    public PhoneMap withPhoneNumber(String value) {
        this.put(PHONE_NUMBER, value);
        return this;
    }

    public PhoneMap withExtension(String value) {
        this.put(EXTENSION, value);
        return this;
    }
}
