package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.VCardAddItem;
import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 09.06.14.
 */
public class VCardAddMap extends ModelBeanMap<VCardAddMap> {
    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String COUNTRY = "country";
    public static final String CITY = "city";
    public static final String WORK_TIME = "workTime";
    public static final String PHONE = "phone";

    public static final String STREET = "street";
    public static final String HOUSE = "house";
    public static final String BUILDING = "building";
    public static final String APARTMENT = "apartment";

    public static final String INSTANT_MESSENGER = "instantMessenger";
    public static final String COMPANY_NAME = "companyName";
    public static final String EXTRA_MESSAGE = "extraMessage";
    public static final String CONTACT_EMAIL = "contactEmail";
    public static final String OGRN = "ogrn";
    public static final String METRO_STATION_ID = "metroStationId";
    public static final String POINT_ON_MAP = "pointOnMap";
    public static final String CONTACT_PERSON = "contactPerson";

    public VCardAddMap() {
        super();
        setBean(new VCardAddItem());
    }

    public VCardAddMap(VCardAddItem vcard) {
        super();
        setBean(vcard);
    }

    public VCardAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VCardAddMap defaultContacts() {
        String extraMsg = "Подробности о товаре. Весь текст составляет в 'длину ровно \"" +
                "\"200 \\ символов. &qoute &mdash & &lquote &rqoute +";
        extraMsg = extraMsg + RandomStringUtils.randomAlphabetic(200 - extraMsg.length());

        this.clear();
        this.withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone())

                .withStreet("вуліца Камуністычная")
                .withHouse("28")
                .withApartment("24")
                .withBuilding("3")
                .withInstantMessenger(new InstantMessengerMap().defaultInstantMessenger())
                .withCompanyName("Питер-сити")
                .withExtraMessage(extraMsg)
                .withContactEmail("at-tester@yandex-team.ru")
                .withOgrn("309547504300018")
                .withContactPerson("Порфирий Покрышкин из API")
                //.withMetroStation(20391l)
                //.withPointOnMap(new MapPointMap().defaultPointOnMap())
                .withContactPerson("Порфирий Покрышкин из API");
        return this;
    }

    public VCardAddMap shortContacts() {
        this.clear();
        this.withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withCompanyName("Питер-сити")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone());
        return this;
    }

    public VCardAddMap withCampaignId(long campaingId) {
        this.put(CAMPAIGN_ID, campaingId);
        return this;
    }

    public VCardAddMap withCountry(String country) {
        this.put(COUNTRY, country);
        return this;
    }

    public VCardAddMap withCity(String city) {
        this.put(CITY, city);
        return this;
    }

    public VCardAddMap withWorkTime(String workTime) {
        this.put(WORK_TIME, workTime);
        return this;
    }

    public VCardAddMap withPhone(PhoneMap phone) {
        this.put(PHONE, (phone == null) ? null : phone.getBean());
        return this;
    }

    public VCardAddMap withStreet(String street) {
        this.put(STREET, street);
        return this;
    }

    public VCardAddMap withHouse(String house) {
        this.put(HOUSE, house);
        return this;
    }

    public VCardAddMap withBuilding(String building) {
        this.put(BUILDING, building);
        return this;
    }

    public VCardAddMap withApartment(String apartment) {
        this.put(APARTMENT, apartment);
        return this;
    }

    public VCardAddMap withInstantMessenger(InstantMessengerMap im) {
        this.put(INSTANT_MESSENGER, (im == null) ? null : im.getBean());
        return this;
    }

    public VCardAddMap withCompanyName(String companyName) {
        this.put(COMPANY_NAME, companyName);
        return this;
    }

    public VCardAddMap withExtraMessage(String extraMessage) {
        this.put(EXTRA_MESSAGE, extraMessage);
        return this;
    }

    public VCardAddMap withContactEmail(String email) {
        this.put(CONTACT_EMAIL, email);
        return this;
    }

    public VCardAddMap withContactPerson(String contactPerson) {
        this.put(CONTACT_PERSON, contactPerson);
        return this;
    }

    public VCardAddMap withPointOnMap(MapPointMap point) {
        this.put(POINT_ON_MAP, (point == null) ? null : point.getBean());
        return this;
    }

    public VCardAddMap withMetroStation(Long stationId) {
        this.put(METRO_STATION_ID, stationId);
        return this;
    }

    public VCardAddMap withOgrn(String ogrn) {
        this.put(OGRN, ogrn);
        return this;
    }
}
