package ru.yandex.autotests.directapi.model.api5.vcards;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.vcards.InstantMessenger;
import com.yandex.direct.api.v5.vcards.MapPoint;
import com.yandex.direct.api.v5.vcards.ObjectFactory;
import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by chicos on 09.06.14.
 */
public class VCardGetMap extends ModelBeanMap<VCardGetMap> {
    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String COUNTRY = "country";
    public static final String CITY = "city";
    public static final String WORK_TIME = "workTime";
    public static final String PHONE = "phone";

    public static final String STREET = "street";
    public static final String HOUSE = "house";
    public static final String BUILDING = "building";
    public static final String APARTMENT = "apartment";

    public static final String INSTANT_MESSENGER = "instantMessenger";
    public static final String COMPANY_NAME = "companyName";
    public static final String EXTRA_MESSAGE = "extraMessage";
    public static final String CONTACT_EMAIL = "contactEmail";
    public static final String OGRN = "ogrn";
    public static final String METRO_STATION_ID = "metroStationId";
    public static final String POINT_ON_MAP = "pointOnMap";
    public static final String CONTACT_PERSON = "contactPerson";

    public VCardGetMap() {
        super();
        setBean(new VCardGetItem());
    }

    public VCardGetMap(VCardGetItem vcard) {
        super();
        setBean(vcard);
    }

    public VCardGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public VCardGetMap defaultContacts() {
        String extraMsg = "Подробности о товаре. Весь текст составляет в 'длину ровно \"" +
                "\"200 \\ символов. &qoute &mdash & &lquote &rqoute +";
        extraMsg = extraMsg + RandomStringUtils.randomAlphabetic(200 - extraMsg.length());

        this.clear();
        this.withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone())

                .withStreet("вуліца Камуністычная")
                .withHouse("28")
                .withApartment("24")
                .withBuilding("3")
                .withInstantMessenger(new InstantMessengerMap().defaultInstantMessenger())
                .withCompanyName("Питер-сити")
                .withExtraMessage(extraMsg)
                .withContactEmail("at-tester@yandex-team.ru")
                .withOGRN("309547504300018")
                .withContactPerson("Порфирий Покрышкин из API")
                .withMetroStation(null)
                //.withMetroStation(20391l)
                .withPointOnMap(null)
                //.withPointOnMap(new MapPointMap().defaultPointOnMap())
                .withContactPerson("Порфирий Покрышкин из API");
        return this;
    }

    public VCardGetMap shortContacts() {
        this.clear();
        this.withCountry("Россия")
                .withCity("Санкт-Петербург")
                .withCompanyName("Питер-сити")
                .withWorkTime("0;3;10;00;18;00;4;6;10;00;11;00")
                .withPhone(new PhoneMap().defaultPhone());
        return this;
    }

    public static String[] shortFieldsSet() {
        return new String[]{CAMPAIGN_ID, COUNTRY, CITY, WORK_TIME, PHONE, COMPANY_NAME};
    }

    public VCardGetMap withId(long id) {
        this.put(ID, id);
        return this;
    }

    public VCardGetMap withCampaignId(long campaingId) {
        this.put(CAMPAIGN_ID, campaingId);
        return this;
    }

    public VCardGetMap withCountry(String country) {
        this.put(COUNTRY, country);
        return this;
    }

    public VCardGetMap withCity(String city) {
        this.put(CITY, city);
        return this;
    }

    public VCardGetMap withWorkTime(String workTime) {
        this.put(WORK_TIME, workTime);
        return this;
    }

    public VCardGetMap withPhone(PhoneMap phone) {
        this.put(PHONE, (phone == null) ? null : phone.getBean());
        return this;
    }

    public VCardGetMap withStreet(String street) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemStreet(street);
        this.put(STREET, jaxbElement);
        return this;
    }

    public VCardGetMap withHouse(String house) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemHouse(house);
        this.put(HOUSE, jaxbElement);
        return this;
    }

    public VCardGetMap withBuilding(String building) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemBuilding(building);
        this.put(BUILDING, jaxbElement);
        return this;
    }

    public VCardGetMap withApartment(String apartment) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemApartment(apartment);
        this.put(APARTMENT, jaxbElement);
        return this;
    }

    public VCardGetMap withInstantMessenger(InstantMessengerMap im) {
        InstantMessenger imBean = (InstantMessenger) ((im == null) ? null : im.getBean());
        JAXBElement<InstantMessenger> jaxbIM = new ObjectFactory().createVCardGetItemInstantMessenger(imBean);
        this.put(INSTANT_MESSENGER, jaxbIM);
        return this;
    }

    public VCardGetMap withCompanyName(String companyName) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemCompanyName(companyName);
        this.put(COMPANY_NAME, jaxbElement);
        return this;
    }

    public VCardGetMap withExtraMessage(String extraMessage) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemExtraMessage(extraMessage);
        this.put(EXTRA_MESSAGE, jaxbElement);
        return this;
    }

    public VCardGetMap withContactEmail(String email) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemContactEmail(email);
        this.put(CONTACT_EMAIL, jaxbElement);
        return this;
    }

    public VCardGetMap withContactPerson(String contactPerson) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemContactPerson(contactPerson);
        this.put(CONTACT_PERSON, jaxbElement);
        return this;
    }

    public VCardGetMap withPointOnMap(MapPointMap point) {
        MapPoint pointBean = (MapPoint) ((point == null) ? null : point.getBean());
        JAXBElement<MapPoint> jaxbElement = new ObjectFactory().createVCardGetItemPointOnMap(pointBean);
        this.put(POINT_ON_MAP, jaxbElement);
        return this;
    }

    public VCardGetMap withMetroStation(Long stationId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createVCardGetItemMetroStationId(stationId);
        this.put(METRO_STATION_ID, jaxbElement);
        return this;
    }

    public VCardGetMap withOGRN(String ogrn) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createVCardGetItemOgrn(ogrn);
        this.put(OGRN, jaxbElement);
        return this;
    }
}
