package ru.yandex.autotests.directapi.model.balance;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 23.10.13
 * Time: 9:56
 * To change this template use File | Settings | File Templates.
 */
public class PaySys {
    public static final int UR = 1003;
    public static final int FIZ = 1001;
    public static final int USP = 1029;
    public static final int SW_YT = 1046;
    public static final int PU = 1018;
    public static final int TRP = 1051;
    public static final int YT_KZP = 1061;
    public static final int KZP = 1021;
    public static final int SW_UR = 1045;
    // не может использоваться
    // https://st.yandex-team.ru/DIRECT-69713#1503645492000
    public static final int BY_YTPH = 1075;
    public static final int SW_PH = 1068;
    public static final int BYU = 1125;
    public static final int BYP = 1126;

    public static int fromValue(String type) {
        switch (type) {
            case "ur":
                return UR;
            case "usp":
                return USP;
            case "sw_yt":
                return SW_YT;
            case "pu":
                return PU;
            case "trp":
                return TRP;
            case "kzp":
                return KZP;
            case "sw_ur":
                return SW_UR;
            case "yt_kzp":
                return YT_KZP;
            case "by_ytph":
                return BY_YTPH;
            case "sw_ph":
                return SW_PH;
            case "byu":
                return BYU;
            case "byp":
                return BYP;
            default:
                return FIZ;
        }
    }
}
