package ru.yandex.autotests.directapi.model.balancesimple.request;


import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.LocalDate;

/**
 * Created by semkagtn on 15.09.15.
 */
public class BindCreditCardRequest extends BalanceSimpleRequest {

    public static final String DEFAULT_CARD_NUMBER = "5105105105105100";
    public static final String DEFAULT_EXPIRATION_MONTH = "07";
    public static final String DEFAULT_EXPIRATION_YEAR = String.valueOf(LocalDate.now().getYearOfCentury() + 1);
    public static final int DEFAULT_REGION_ID = 225;
    public static final String DEFAULT_CVN = "300";
    public static final String DEFAULT_CARD_HOLDER = "TEST";

    @JsonProperty("card_number")
    private String cardNumber;

    @JsonProperty("expiration_year")
    private String expirationYear;

    @JsonProperty("expiration_month")
    private String expirationMonth;

    @JsonProperty("region_id")
    private Integer regionId;

    @JsonProperty("cvn")
    private String cvn;

    @JsonProperty("cardholder")
    private String cardHolder;

    public String getCardNumber() {
        return cardNumber;
    }

    public String getExpirationYear() {
        return expirationYear;
    }

    public String getExpirationMonth() {
        return expirationMonth;
    }

    public Integer getRegionId() {
        return regionId;
    }

    public String getCvn() {
        return cvn;
    }

    public String getCardHolder() {
        return cardHolder;
    }

    public BindCreditCardRequest withCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    public BindCreditCardRequest withExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    public BindCreditCardRequest withExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    public BindCreditCardRequest withRegionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    public BindCreditCardRequest withCvn(String cvn) {
        this.cvn = cvn;
        return this;
    }

    public BindCreditCardRequest withCardHolder(String cardHolder) {
        this.cardHolder = cardHolder;
        return this;
    }

    public BindCreditCardRequest defaultCreditCard() {
        return withExpirationYear(DEFAULT_EXPIRATION_YEAR)
                .withCardNumber(DEFAULT_CARD_NUMBER)
                .withExpirationMonth(DEFAULT_EXPIRATION_MONTH)
                .withRegionId(DEFAULT_REGION_ID)
                .withCvn(DEFAULT_CVN)
                .withCardHolder(DEFAULT_CARD_HOLDER);
    }
}
