package ru.yandex.autotests.directapi.model.balancesimple.response;


import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

/**
 * Created by semkagtn on 15.09.15.
 */
public class ListPaymentMethodResponse extends BalanceSimpleResponse {

    @JsonProperty("payment_methods")
    @JsonDeserialize(using = PaymentMethodsDeserializer.class)
    private Map<String, PaymentMethod> paymentMethods;

    public Map<String, PaymentMethod> getPaymentMethods() {
        return paymentMethods;
    }


    public static class PaymentMethodsDeserializer extends JsonDeserializer<Map<String, PaymentMethod>> {

        @Override
        public Map<String, PaymentMethod> deserialize(
                JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException
        {
            Map<String, PaymentMethod> result = new HashMap<>();
            ObjectCodec objectCodec = jsonParser.getCodec();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode node = objectCodec.readTree(jsonParser);
            node.fields().forEachRemaining(x -> {
                try {
                    result.put(x.getKey(), objectMapper.readValue(x.getValue().toString(), PaymentMethod.class));
                } catch (IOException e) {
                    throw new DirectAPIException("Не удалось распарсить ответ", e);
                }
            });
            return result;
        }
    }
}
