package ru.yandex.autotests.directapi.model.banners;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 10.12.12
 * Time: 13:40
 * To change this template use File | Settings | File Templates.
 */
public enum AgeLabel {

    MONTHS0("0months", AgeLabelEnum.MONTHS_0),
    MONTHS1("1months", AgeLabelEnum.MONTHS_1),
    MONTHS2("2months", AgeLabelEnum.MONTHS_2),
    MONTHS3("3months", AgeLabelEnum.MONTHS_3),
    MONTHS4("4months", AgeLabelEnum.MONTHS_4),
    MONTHS5("5months", AgeLabelEnum.MONTHS_5),
    MONTHS6("6months", AgeLabelEnum.MONTHS_6),
    MONTHS7("7months", AgeLabelEnum.MONTHS_7),
    MONTHS8("8months", AgeLabelEnum.MONTHS_8),
    MONTHS9("9months", AgeLabelEnum.MONTHS_9),
    MONTHS10("10months", AgeLabelEnum.MONTHS_10),
    MONTHS11("11months", AgeLabelEnum.MONTHS_11),
    MONTHS12("12months", AgeLabelEnum.MONTHS_12),
    PLUS0("0+", AgeLabelEnum.AGE_0),
    PLUS6("6+", AgeLabelEnum.AGE_6),
    PLUS12("12+", AgeLabelEnum.AGE_12),
    PLUS16("16+", AgeLabelEnum.AGE_16),
    PLUS18("18+", AgeLabelEnum.AGE_18);

    private String ageLabel;
    private AgeLabelEnum ageLabelV5;

    private AgeLabel(String ageLabel, AgeLabelEnum ageLabelV5) {
        this.ageLabel = ageLabel;
        this.ageLabelV5 = ageLabelV5;
    }

    public String getAgeLabel() {
        return ageLabel;
    }

    public AgeLabelEnum getAgeLabelV5() {
        return ageLabelV5;
    }

    @Override
    public String toString() {
        return getAgeLabel();
    }

    public static AgeLabel[] monthValues() {
        return new AgeLabel[]{MONTHS0, MONTHS1, MONTHS2, MONTHS3, MONTHS4, MONTHS5, MONTHS6, MONTHS7, MONTHS8, MONTHS9,
                MONTHS10, MONTHS11, MONTHS12};
    }

    public static AgeLabel[] yearValues() {
        return new AgeLabel[]{PLUS0, PLUS6, PLUS12, PLUS16, PLUS18};
    }
}
