package ru.yandex.autotests.directapi.model.banners;

import com.google.common.primitives.Ints;
import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 13.06.13
 * Time: 1:30
 * To change this template use File | Settings | File Templates.
 */
public class CampaignBidsInfoMap<T> extends ModelBeanMap<CampaignBidsInfoMap> {

    public static final int MAX_BANNER_IDS_LENGTH = 2000;

    //region Fields
    private static final String CAMPAIGN_BIDS_INFO = "CampaignBidsInfo";

    public static final String CAMPAIGN_ID = "campaignID";
    public static final String BANNER_IDS = "bannerIDS";
    //endregion

    public CampaignBidsInfoMap(String packageName) {
        super(packageName, CAMPAIGN_BIDS_INFO);
    }

    public CampaignBidsInfoMap(T campaignBidsInfo) {
        super();
        setBean(campaignBidsInfo);
    }

    //region Builder
    public CampaignBidsInfoMap withCampaignID(Integer campaignID) {
        put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public CampaignBidsInfoMap withCampaignID(Long campaignID) {
        put((CAMPAIGN_ID), Ints.checkedCast(campaignID));
        return this;
    }

    public CampaignBidsInfoMap withBannerIDS(Long... bannerIDS) {
        put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }
    //endregion


}
