package ru.yandex.autotests.directapi.model.banners;

import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * User: mariabye
 * Date: 24.06.13
 */
public class ContactInfoMap<ContactInfo> extends ModelBeanMap<ContactInfoMap> {
    //region Fields
    private static final String CONTACT_INFO = "ContactInfo";

    public static final String WORK_TIME = "workTime";
    public static final String CONTACT_PERSON = "contactPerson";
    public static final String EXTRA_MESSAGE = "extraMessage";
    public static final String IM_CLIENT = "IMClient";
    public static final String IM_LOGIN = "IMLogin";
    public static final String COUNTRY = "country";
    public static final String COUNTRY_CODE = "countryCode";
    public static final String CITY = "city";
    public static final String STREET = "street";
    public static final String HOUSE = "house";
    public static final String APART = "apart";
    public static final String BUILD = "build";

    public static final String COMPANY_NAME = "companyName";
    public static final String CONTACT_EMAIL = "contactEmail";
    public static final String CITY_CODE = "cityCode";
    public static final String PHONE = "phone";
    public static final String PHONE_EXT = "phoneExt";
    public static final String OGRN = "OGRN";
    public static final String POINT_ON_MAP = "pointOnMap";

    //endregion

    //region possible values
    public static String DEFAULT_EMAIL = "at-tester@yandex-team.ru";
    //endregion

    public ContactInfoMap(String packageName) {
        super(packageName, CONTACT_INFO);
    }

    public ContactInfoMap(ContactInfo contactInfo) {
        super();
        setBean(contactInfo);
    }

    public ContactInfoMap put(String fieldName, Object value) {
        super.put((fieldName), value);
        return this;
    }

    //region Builder
    public ContactInfoMap defaultContacts() {
        this.clear();
        this.put((WORK_TIME), "0;3;10;00;18;00;4;6;10;00;11;00");
        this.put((CONTACT_PERSON), "Тестировщик API");
        String extraMsg = "Подробности о товаре. Весь текст составляет в 'длину ровно \"" +
                "\"200 \\ символов. &qoute &mdash & &lquote &rqoute +";
        extraMsg = extraMsg + RandomStringUtils.randomAlphabetic(200 - extraMsg.length());
        this.put((EXTRA_MESSAGE), extraMsg);
        this.put((IM_CLIENT), IMClient.ICQ);
        this.put((IM_LOGIN), "456789123");
        this.put((COUNTRY), "Россия");
        this.put((CITY), "Санкт-Петербург");
        this.put((STREET), "Пискаревский");
        this.put((HOUSE), "44");
        this.put((APART), "24");
        this.put((BUILD), "3");
        this.put((COMPANY_NAME), "Питер-сити");
        this.put((CONTACT_EMAIL), DEFAULT_EMAIL);
        this.put((COUNTRY_CODE), "+7");
        this.put((CITY_CODE), "812");
        this.put((PHONE), "123-45-67");
        this.put((PHONE_EXT), "89");
        this.put((OGRN), "309547504300018");
        this.put((POINT_ON_MAP), new PointOnMapMap(super.getPackageName()).defaultPointOnMap().getBean());
        return this;
    }

    public ContactInfoMap defaultContactsKiev() {
        this.clear();
        this.put((WORK_TIME), "0;2;9;00;17;00;3;6;11;00;15;00");
        this.put((CONTACT_PERSON), RandomStringUtils.randomAlphabetic(10));
        String extraMsg = "Подробности о товаре. Весь текст составляет в 'длину ровно \"" +
                "\"200 \\ символов. &qoute &mdash & &lquote &rqoute +";
        extraMsg = extraMsg + RandomStringUtils.randomAlphabetic(200 - extraMsg.length());
        this.put((EXTRA_MESSAGE), extraMsg);
        this.put((IM_CLIENT), IMClient.ICQ);
        this.put((IM_LOGIN), "435234543");
        this.put((COUNTRY), "Украина");
        this.put((CITY), "Киев");
        this.put((STREET), "переулок Тараса Шевченко");
        this.put((HOUSE), "8А");
        this.put((APART), "24");
        this.put((COMPANY_NAME), "Литературно-мемориальный дом-музей Т.Г. Шевченко");
        this.put((CONTACT_EMAIL), DEFAULT_EMAIL);
        this.put((COUNTRY_CODE), "+380");
        this.put((CITY_CODE), "44");
        this.put((PHONE), "278-35-11");
        this.put((PHONE_EXT), "83769");
        this.put((POINT_ON_MAP),
                new PointOnMapMap(super.getPackageName()).point(
                        30.520307f,
                        50.451055f,
                        30.518259f,
                        50.449747f,
                        30.522355f,
                        50.452362f
                ).getBean());
        return this;
    }

    public ContactInfoMap withIMClient(String imClient) {
        this.put((IM_CLIENT), imClient);
        return this;
    }

    public ContactInfoMap withIMLogin(String imLogin) {
        this.put((IM_LOGIN), imLogin);
        return this;
    }

    public ContactInfoMap withCountry(String country) {
        this.put((COUNTRY), country);
        return this;
    }

    public ContactInfoMap withCountryCode(String countryCode) {
        this.put((COUNTRY_CODE), countryCode);
        return this;
    }

    public ContactInfoMap withCityCode(String cityCode) {
        this.put((CITY_CODE), cityCode);
        return this;
    }

    public ContactInfoMap withWorkTime(String workTime) {
        this.put(WORK_TIME, workTime);
        return this;
    }

    public ContactInfoMap withContactPerson(String contactPerson) {
        this.put(CONTACT_PERSON, contactPerson);
        return this;
    }

    public ContactInfoMap withCity(String city) {
        this.put(CITY, city);
        return this;
    }

    public ContactInfoMap withStreet(String street) {
        this.put(STREET, street);
        return this;
    }

    public ContactInfoMap withHouse(String house) {
        this.put(HOUSE, house);
        return this;
    }

    public ContactInfoMap withBuild(String build) {
        this.put(BUILD, build);
        return this;
    }

    public ContactInfoMap withApart(String apart) {
        this.put(APART, apart);
        return this;
    }

    public ContactInfoMap withPhone(String phone) {
        this.put(PHONE, phone);
        return this;
    }

    public ContactInfoMap withPhoneExt(String phoneExt) {
        this.put(PHONE_EXT, phoneExt);
        return this;
    }

    public ContactInfoMap withCompanyName(String companyName) {
        this.put(COMPANY_NAME, companyName);
        return this;
    }

    public ContactInfoMap withExtraMessage(String extraMessage) {
        this.put(EXTRA_MESSAGE, extraMessage);
        return this;
    }

    public ContactInfoMap withContactEmail(String contactEmail) {
        this.put(CONTACT_EMAIL, contactEmail);
        return this;
    }

    public ContactInfoMap withOGRN(String ogrn) {
        this.put(OGRN, ogrn);
        return this;
    }

    public ContactInfoMap withPointOnMap(PointOnMapMap pointOnMapMap) {
        this.put(POINT_ON_MAP, (pointOnMapMap == null) ? null : pointOnMapMap.getBean());
        return this;
    }
}
