package ru.yandex.autotests.directapi.model.banners;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.model.common.Value;


/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 13.06.13
 * Time: 1:30
 * To change this template use File | Settings | File Templates.
 */
public class GetBannersInfoMap<T> extends ModelBeanMap<GetBannersInfoMap> {
    //region Fields
    private static final String GET_BANNERS_INFO = "GetBannersInfo";

    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String BANNER_IDS = "bannerIDS";
    public static final String GET_PHRASES = "getPhrases";
    public static final String FIELDS_NAMES = "fieldsNames";
    public static final String FILTER = "filter";
    public static final String CURRENCY = "currency";
    public static final String AUCTION_BIDS = "auctionBids";

    //endregion

    //region field possible values
    public final class GetPhrases {
        public static final String YES = Value.YES;
        public static final String NO = Value.NO;
        public static final String WITH_PRICES = "WithPrices";
    }
    //endregion

    public GetBannersInfoMap(String packageName) {
        super(packageName, GET_BANNERS_INFO);
    }

    public GetBannersInfoMap(T getBannersInfo) {
        super();
        setBean(getBannersInfo);
    }

    //region Builder
    public GetBannersInfoMap withCampaignIDS(Integer... campaignIDS) {
        put((CAMPAIGN_IDS), ArrayUtils.toPrimitive(campaignIDS));
        return this;
    }

    public GetBannersInfoMap withBannerIDS(Long... bannerIDS) {
        put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public GetBannersInfoMap withGetPhrases(String phrasesFilter) {
        put((GET_PHRASES), phrasesFilter);
        return this;
    }

    public GetBannersInfoMap withFieldsNames(String... fieldsNames) {
        put((FIELDS_NAMES), fieldsNames);
        return this;
    }

    public GetBannersInfoMap withFilter(BannersFilterInfoMap bannersFilterInfoMap) {
        put(FILTER, bannersFilterInfoMap.getBean());
        return this;
    }

    public GetBannersInfoMap withCurrency(Currency currency) {
        if (currency != null && currency != Currency.YND_FIXED) {
            this.put((CURRENCY), currency.value());
        } else {
            this.put((CURRENCY), null);
        }
        return this;
    }

    public GetBannersInfoMap withAuctionBids(String auctionBids) {
        put((AUCTION_BIDS), auctionBids);
        return this;
    }
    //endregion

}
