package ru.yandex.autotests.directapi.model.banners;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10/15/14.
 */
public class KeywordActionResultMap<T> extends ModelBeanMap<KeywordActionResultMap> {

    //region Fields
    private static final String KEYWORD_ACTION_RESULT = "KeywordActionResult";

    public static final String KEYWORD_ID = "keywordID";
    public static final String QUALITY_INDEX = "qualityIndex";
    //endregion

    public KeywordActionResultMap(String packageName) {
        super(packageName, KEYWORD_ACTION_RESULT);
    }

    public KeywordActionResultMap(T keywordActionResult) {
        super();
        setBean(keywordActionResult);
    }

    //region Builder
    public KeywordActionResultMap withKeywordID(long keywordID) {
        put(KEYWORD_ID, keywordID);
        return this;
    }

    public KeywordActionResultMap withQualityIndex(QualityIndexMap qualityIndexMap) {
        put(QUALITY_INDEX, qualityIndexMap);
        return this;
    }
    //endregion
}
