package ru.yandex.autotests.directapi.model.banners;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.apiclient.methods.Action;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 13.03.14
 * Time: 10:59
 * To change this template use File | Settings | File Templates.
 */
public class KeywordRequestMap<T> extends ModelBeanMap<KeywordRequestMap> {
    //region Fields
    private static final String KEYWORD_REQUEST = "KeywordRequest";

    public static final String ACTION = "action";
    public static final String LOGIN = "login";
    public static final String KEYWORD_IDS = "keywordIDS";
    //endregion

    public KeywordRequestMap(String packageName) {
        super(packageName, KEYWORD_REQUEST);
    }

    public KeywordRequestMap(T keywordRequest) {
        super();
        setBean(keywordRequest);
    }

    //region Builder
    public KeywordRequestMap withAction(String action) {
        put((ACTION), action);
        return this;
    }

    public KeywordRequestMap withAction(Action action) {
        this.put((ACTION), action.getAction());
        return this;
    }

    public KeywordRequestMap withLogin(String login) {
        put((LOGIN), login);
        return this;
    }

    public KeywordRequestMap withKeywordIDS(long... keywordIDS) {
        put((KEYWORD_IDS), keywordIDS);
        return this;
    }
    //endregion


}
