package ru.yandex.autotests.directapi.model.banners;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 05.02.14.
 */
public class PointOnMapMap<T> extends ModelBeanMap<PointOnMapMap> {
    private static final String MAP_POINT = "MapPoint";

    public static final String X = "x";
    public static final String Y = "y";
    public static final String X_1 = "x1";
    public static final String Y_1 = "y1";
    public static final String X_2 = "x2";
    public static final String Y_2 = "y2";

    public PointOnMapMap(String packageName) {
        super(packageName, MAP_POINT);
    }

    public PointOnMapMap(T pointOnMap) {
        super();
        setBean(pointOnMap);
    }

    public PointOnMapMap defaultPointOnMap() {
        this.clear();
        this.put((X), 45.733604f);
        this.put((Y), 45.724312f);
        this.put((X_1), 27.603738f);
        this.put((Y_1), 27.587272f);
        this.put((X_2), 27.570806f);
        this.put((Y_2), 45.742894f);
        return this;
    }


    public PointOnMapMap point(float x, float y, float x1, float y1, float x2, float y2) {
        withX(x);
        withY(y);
        withX1(x1);
        withY1(y1);
        withX2(x2);
        withY2(y2);
        return this;
    }

    public PointOnMapMap withX(float value) {
        this.put((X), value);
        return this;
    }

    public PointOnMapMap withY(float value) {
        this.put((Y), value);
        return this;
    }

    public PointOnMapMap withX1(float value) {
        this.put((X_1), value);
        return this;
    }

    public PointOnMapMap withY1(float value) {
        this.put((Y_1), value);
        return this;
    }

    public PointOnMapMap withX2(float value) {
        this.put((X_2), value);
        return this;
    }

    public PointOnMapMap withY2(float value) {
        this.put((Y_2), value);
        return this;
    }

}
