package ru.yandex.autotests.directapi.model.banners;

import java.math.BigDecimal;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10/15/14.
 */
public class QualityIndexMap<T> extends ModelBeanMap<QualityIndexMap> {

    //region Fields
    private static final String QUALITY_INDEX = "QualityIndex";

    public static final String VALUE = "value";
    public static final String REFERENCES = "references";
    //endregion

    public QualityIndexMap(String packageName) {
        super(packageName, QUALITY_INDEX);
    }

    public QualityIndexMap(T qualityIndex) {
        super();
        setBean(qualityIndex);
    }

    //region Builder
    public QualityIndexMap withValue(BigDecimal value) {
        put(VALUE, value);
        return this;
    }

    public QualityIndexMap withReferences(int[] references) {
        put(REFERENCES, references);
        return this;
    }
    //endregion
}
