package ru.yandex.autotests.directapi.model.banners.phrases;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.PhraseTexts;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 24.06.13
 * Time: 22:09
 * To change this template use File | Settings | File Templates.
 */
public class BannerPhraseInfoMap<T> extends ModelBeanMap<BannerPhraseInfoMap> {

    public static final int MAX_PHRASE_LENGTH = KeywordsSteps.PHRASE_MAX_LENGTH;

    public static final int KEYWORD_MAX_LENGTH = KeywordsSteps.KEYWORD_MAX_LENGTH;
    public static final int MINUS_WORD_MAX_LENGTH = KeywordsSteps.MINUS_WORD_MAX_LENGTH;
    public static final int MAX_PLUS_WORDS_IN_PHRASE = KeywordsSteps.MAX_PLUS_WORDS_IN_PHRASE;

    // приемлемая длина ключевого слова
    public static final int ACCEPTABLE_KEYWORD_LENGTH = KeywordsSteps.ACCEPTABLE_KEYWORD_LENGTH;

    public static final String CYRILLIC_CHARS_NO_SPACE = KeywordsSteps.CYRILLIC_CHARS_NO_SPACE;

    //region Fields
    private static final String BANNER_PHRASE_INFO = "BannerPhraseInfo";

    public static final String PHRASE = "phrase";
    public static final String IS_RUBRIC = "isRubric";
    public static final String PRICE = "price";
    public static final String CONTEXT_PRICE = "contextPrice";
    public static final String AD_GROUP_ID = "adGroupID";
    public static final String CAMPAIGN_ID = "campaignID";
    public static final String BANNER_ID = "bannerID";
    public static final String PHRASE_ID = "phraseID";
    public static final String AUTO_BROKER = "autoBroker";
    public static final String AUTO_BUDGET_PRIORITY = "autoBudgetPriority";
    public static final String CLICKS = "clicks";
    public static final String SHOWS = "shows";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String PREMIUM_MIN = "premiumMin";
    public static final String PREMIUM_MAX = "premiumMax";
    public static final String STATUS_PAUSED = "statusPaused";
    public static final String CURRENCY = "currency";
    public static final String USER_PARAMS = "userParams";
    public static final String STATUS_PHRASE_MODERATE = "statusPhraseModerate";
    public static final String CONTEXT_CLICKS = "contextClicks";
    public static final String CONTEXT_SHOWS = "contextShows";
    public static final String LOW_CTR_WARNING = "lowCTRWarning";
    public static final String LOW_CTR = "lowCTR";
    public static final String CONTEXT_LOW_CTR = "contextLowCTR";
    public static final String COVERAGE = "coverage";
    public static final String CONTEXT_COVERAGE = "contextCoverage";
    public static final String PRICES = "prices";
    public static final String CURRENT_ON_SEARCH = "currentOnSearch";
    public static final String MIN_PRICE = "minPrice";
    public static final String CTR = "CTR";
    public static final String AUCTION_BIDS = "auctionBids";

    public static final String[] fields = new String[]{
            capitalize(BANNER_ID),
            capitalize(CAMPAIGN_ID),
            capitalize(AD_GROUP_ID),
            capitalize(PHRASE_ID),
            capitalize(PHRASE),
            capitalize(IS_RUBRIC),
            capitalize(PRICE),
            capitalize(CONTEXT_PRICE),
            capitalize(AUTO_BROKER),
            capitalize(USER_PARAMS),
            capitalize(STATUS_PHRASE_MODERATE),
            capitalize(AUTO_BUDGET_PRIORITY),
            capitalize(CLICKS),
            capitalize(SHOWS),
            capitalize(CONTEXT_CLICKS),
            capitalize(CONTEXT_SHOWS),
            capitalize(MIN),
            capitalize(MAX),
            capitalize(PREMIUM_MIN),
            capitalize(PREMIUM_MAX),
            capitalize(LOW_CTR_WARNING),
            capitalize(LOW_CTR),
            capitalize(CONTEXT_LOW_CTR),
            capitalize(COVERAGE),
            capitalize(CONTEXT_COVERAGE),
            capitalize(PRICES),
            capitalize(CURRENT_ON_SEARCH),
            capitalize(MIN_PRICE),
            capitalize(STATUS_PAUSED),
            capitalize(CURRENCY),
            capitalize(AUCTION_BIDS)
    };
    //endregion

    public BannerPhraseInfoMap(String packageName) {
        super(packageName, BANNER_PHRASE_INFO);
    }

    public BannerPhraseInfoMap(T bannerPhraseInfo) {
        super();
        setBean(bannerPhraseInfo);
    }

    //region Builder
    public BannerPhraseInfoMap withTextPhrase(String keyword) {
        this.put((PHRASE), keyword);
        this.put((IS_RUBRIC), Value.NO);
        return this;
    }

    public BannerPhraseInfoMap withAutoBroker(String value) {
        this.put((AUTO_BROKER), value);
        return this;
    }

    public BannerPhraseInfoMap withRubric(String keyword) {
        this.put((PHRASE), keyword);
        this.put((IS_RUBRIC), Value.YES);
        return this;
    }

    public BannerPhraseInfoMap withPrice(Float price) {
        this.put((AUTO_BUDGET_PRIORITY), null);
        this.put((PRICE), price);
        return this;
    }

    public BannerPhraseInfoMap withContextPrice(Float price) {
        this.put((AUTO_BUDGET_PRIORITY), null);
        this.put((CONTEXT_PRICE), price);
        return this;
    }

    public BannerPhraseInfoMap withAutoBudgetPriority(String autoBudgetPriority) {
        this.put((AUTO_BUDGET_PRIORITY), autoBudgetPriority);
        this.put((PRICE), null);
        return this;
    }

    public BannerPhraseInfoMap withBannerId(String bannerId) {
        this.put((BANNER_ID), bannerId);
        return this;
    }

    public BannerPhraseInfoMap withPhraseId(String phraseId) {
        this.put((PHRASE_ID), phraseId);
        return this;
    }

    public BannerPhraseInfoMap withCampaignId(String campaignId) {
        this.put((CAMPAIGN_ID), campaignId);
        return this;
    }

    public BannerPhraseInfoMap defaultTextPhrase() {
        this.withTextPhrase(PhraseTexts.getRandom())
                .withPrice(0.01f);
        return this;
    }

    public BannerPhraseInfoMap secondDefaultTextPhrase() {
        this.withTextPhrase("новогодние подарки")
                .withPrice(0.01f);
        return this;
    }

    public BannerPhraseInfoMap defaultEnglishTextPhrase() {
        this.withTextPhrase("english phrase")
                .withPrice(0.01f);
        return this;
    }

    public BannerPhraseInfoMap defaultRubric() {
        this.withRubric(String.valueOf(Categories.OKNA))
                .withPrice(0.01f);
        return this;
    }

    public BannerPhraseInfoMap withUserParams(PhraseUserParamsMap phraseUserParamsMap) {
        this.put((USER_PARAMS), phraseUserParamsMap.getBean());
        return this;
    }

    public BannerPhraseInfoMap withCurrency(String currency) {
        this.put((CURRENCY), currency);
        return this;
    }

    public static List<String> getMinusWords(int lengthLimit) {
        List<String> words = new ArrayList<String>();
        int count = lengthLimit / 10;
        for (int i = 0; i < count; i++) {
            words.add(" -" + RandomStringUtils.randomAlphabetic(8));
        }
        return words;
    }

    public BannerPhraseInfoMap withIsRubric(String yesNoValue) {
        this.put(IS_RUBRIC, yesNoValue);
        return this;
    }

    public BannerPhraseInfoMap withStatusPaused(String statusPaused) {
        this.put(STATUS_PAUSED, statusPaused);
        return this;
    }
}
