package ru.yandex.autotests.directapi.model.banners.phrases;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 18.09.13
 * Time: 11:41
 * To change this template use File | Settings | File Templates.
 */
public class BannerPhrasesFilterRequestInfoMap<T> extends ModelBeanMap<BannerPhrasesFilterRequestInfoMap> {
    private static final String BANNER_PHRASES_FILTER_REQUEST_INFO = "BannerPhrasesFilterRequestInfo";

    public static final String BANNER_IDS = "bannerIDS";
    public static final String FIELDS_NAMES = "fieldsNames";
    public static final String CONSIDER_TIME_TARGET = "considerTimeTarget";
    public static final String REQUEST_PRICES = "requestPrices";
    public static final String CURRENCY = "currency";


    public BannerPhrasesFilterRequestInfoMap(String packageName) {
        super(packageName, BANNER_PHRASES_FILTER_REQUEST_INFO);
    }

    public BannerPhrasesFilterRequestInfoMap(T bannerPhrasesFilterRequestInfo) {
        super();
        setBean(bannerPhrasesFilterRequestInfo);
    }

    public BannerPhrasesFilterRequestInfoMap withBannerIDS(Long... bannerIDS) {
        put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }

    public BannerPhrasesFilterRequestInfoMap withFieldsNames(String... fieldsNames) {
        put((FIELDS_NAMES), fieldsNames);
        return this;
    }

    public BannerPhrasesFilterRequestInfoMap withCurrency(String currency) {
        put((CURRENCY), currency);
        return this;
    }

    public BannerPhrasesFilterRequestInfoMap withRequestPrices(String requestPrices) {
        put((REQUEST_PRICES), requestPrices);
        return this;
    }
}
