package ru.yandex.autotests.directapi.model.banners.phrases;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 20.07.15.
 */
public class PhraseAuctionBidMap<T> extends ModelBeanMap<PhraseAuctionBidMap> {

    private static final String PHRASE_AUCTION_BIDS = "PhraseAuctionBids";
    public static final String PRICE = "price";
    public static final String BID = "bid";
    public static final String POSITION = "position";

    public PhraseAuctionBidMap(String packageName) {
        super(packageName, PHRASE_AUCTION_BIDS);
    }

    public PhraseAuctionBidMap(T phraseAuctionBid) {
        super();
        setBean(phraseAuctionBid);
    }

    public PhraseAuctionBidMap withPrice(Float price) {
        this.put((PRICE), price);
        return this;
    }

    public PhraseAuctionBidMap withBid(Float bid) {
        this.put((BID), bid);
        return this;
    }

    public PhraseAuctionBidMap withPosition(String position) {
        this.put((POSITION), position);
        return this;
    }
}
