package ru.yandex.autotests.directapi.model.banners.tags;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 11:11
 * To change this template use File | Settings | File Templates.
 */
public class BannerTagsInfoMap<T> extends ModelBeanMap<BannerTagsInfoMap> {

    public static final int MAX_TAG_IDS_LENGTH = 30;

    //region Fields
    private static final String BANNER_TAGS_INFO = "BannerTagsInfo";

    public static final String BANNER_ID = "bannerID";
    public static final String TAG_IDS = "tagIDS";
    //endregion

    public BannerTagsInfoMap(String packageName) {
        super(packageName, BANNER_TAGS_INFO);
    }

    public BannerTagsInfoMap(T bannerTagsInfoMap) {
        setBean(bannerTagsInfoMap);
    }


    //region Builder
    public BannerTagsInfoMap withBannerID(Long bannerID) {
        put((BANNER_ID), bannerID);
        return this;
    }

    public BannerTagsInfoMap withTags(int... tagIDs) {
        put(TAG_IDS, tagIDs);
        return this;
    }
    //endregion


}
