package ru.yandex.autotests.directapi.model.banners.tags;

import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 09.10.13
 * Time: 21:59
 * To change this template use File | Settings | File Templates.
 */
public class BannersRequestInfoMap<T> extends ModelBeanMap<BannersRequestInfoMap> {

    public static final int MAX_CAMPAIGN_IDS_LENGTH = 10;
    public static final int MAX_BANNER_IDS_LENGTH = 2000;

    //region Fields
    private static final String BANNERS_REQUEST_INFO = "BannersRequestInfo";

    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String BANNER_IDS = "bannerIDS";
    //endregion

    public BannersRequestInfoMap(String packageName) {
        super(packageName, BANNERS_REQUEST_INFO);
    }

    public BannersRequestInfoMap(T bannerRequestInfo) {
        super();
        setBean(bannerRequestInfo);
    }


    //region Builder
    public BannersRequestInfoMap withCampaignIDS(int... campaignIDS) {
        put((CAMPAIGN_IDS), campaignIDS);
        return this;
    }

    public BannersRequestInfoMap withBannerIDS(Long... bannerIDS) {
        put((BANNER_IDS), ArrayUtils.toPrimitive(bannerIDS));
        return this;
    }
    //endregion
}
