package ru.yandex.autotests.directapi.model.banners.tags;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 11:11
 * To change this template use File | Settings | File Templates.
 */
public class CampaignTagsInfoMap<T> extends ModelBeanMap<CampaignTagsInfoMap> {

    public static final int MAX_TAGS_LENGTH = 200;

    //region Fields
    private static final String CAMPAIGN_TAGS_INFO = "CampaignTagsInfo";

    public static final String CAMPAIGN_ID = "campaignID";
    public static final String TAGS = "tags";
    //endregion

    public CampaignTagsInfoMap(String packageName) {
        super(packageName, CAMPAIGN_TAGS_INFO);
    }

    public CampaignTagsInfoMap(T campaignTagsInfo) {
        setBean(campaignTagsInfo);
    }


    //region Builder
    public CampaignTagsInfoMap withCampaignID(Integer campaignID) {
        put((CAMPAIGN_ID), campaignID);
        return this;
    }

    public <T> CampaignTagsInfoMap withTags(TagInfoMap... tagInfoMaps) {
        put((TAGS), convert(tagInfoMaps, new BeanMapToBeanConverter())
                .toArray((Object[]) Array.newInstance(new TagInfoMap<>(super.getPackageName())
                        .getBean().getClass(), 0)));
        return this;
    }
    //endregion


}