package ru.yandex.autotests.directapi.model.banners.tags;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 10.10.13
 * Time: 11:29
 * To change this template use File | Settings | File Templates.
 */
public class TagInfoMap<T> extends ModelBeanMap<TagInfoMap> {

    public static final int MAX_TAG_LENGTH = 25;

    //region Fields
    private static final String TAG_INFO = "TagInfo";

    public static final String TAG_ID = "tagID";
    public static final String TAG = "tag";
    //endregion

    public TagInfoMap(String packageName) {
        super(packageName, TAG_INFO);
    }

    public TagInfoMap(T tagInfo) {
        super();
        setBean(tagInfo);
    }


    //region Builder
    public TagInfoMap withTagID(Integer tagID) {
        put((TAG_ID), tagID);
        return this;
    }

    public TagInfoMap withTag(String tag) {
        put((TAG), tag);
        return this;
    }
    //endregion

}
