package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 18.10.13
 * Time: 15:56
 * To change this template use File | Settings | File Templates.
 */
public class CampaignIDInfoMap<T> extends ModelBeanMap<CampaignIDInfoMap> {
    private static String CAMPAIGN_ID_INFO = "CampaignIDInfo";

    public static final String CAMPAIGN_ID = "campaignID";
    public static final String CURRENCY = "currency";


    public CampaignIDInfoMap(String packageName) {
        super(packageName, CAMPAIGN_ID_INFO);
    }

    public CampaignIDInfoMap(T campaignIDInfo) {
        super();
        setBean(campaignIDInfo);
    }

    public CampaignIDInfoMap withCampaignID(Integer campaignID) {
        put(CAMPAIGN_ID, campaignID);
        return this;
    }

    public CampaignIDInfoMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }

    public CampaignIDInfoMap withCurrency(Currency currency) {
        if (currency != null) {
            put(CURRENCY, currency.toString());
        }
        return this;
    }

}
