package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 18.10.13
 * Time: 15:56
 * To change this template use File | Settings | File Templates.
 */
public class CampaignIDsInfoMap<T> extends ModelBeanMap<CampaignIDsInfoMap> {
    public static final String CAMPAIGN_IDS = "campaignIDS";
    public static final String CURRENCY = "currency";
    private static String CAMPAIGN_IDS_INFO = "CampaignIDSInfo";

    public CampaignIDsInfoMap(String packageName) {
        super(packageName, CAMPAIGN_IDS_INFO);
    }


    public CampaignIDsInfoMap(T campaignIDsInfo) {
        super();
        setBean(campaignIDsInfo);
    }

    public CampaignIDsInfoMap withCampaignIDs(int... campaignIds) {
        put(CAMPAIGN_IDS, campaignIds);
        return this;
    }

    public CampaignIDsInfoMap withCurrency(String currency) {
        put(CURRENCY, currency);
        return this;
    }

    public CampaignIDsInfoMap withCurrency(Currency currency) {
        if (currency != null) {
            put(CURRENCY, currency.toString());
        }
        return this;
    }

}
