package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Money;

/**
 * Created by mariabye on 05.02.14.
 */
public class DayBudgetInfoMap<T> extends ModelBeanMap<DayBudgetInfoMap> {
    private static final String DAY_BUDGET_INFO = "DayBudgetInfo";
    public static final String AMOUNT = "amount";
    public static final String SPEND_MODE = "spendMode";

    //region possible values
    public static final String SPEND_MODE_DEFAULT = "Default";
    public static final String SPEND_MODE_STRETCHED = "Stretched";
    //endregion

    public DayBudgetInfoMap(String packageName) {
        super(packageName, DAY_BUDGET_INFO);
    }

    public DayBudgetInfoMap(T dayBudgetInfo) {
        setBean(dayBudgetInfo);
    }

    public DayBudgetInfoMap withAmount(Float amount) {
        put(AMOUNT, amount);
        return this;
    }

    public DayBudgetInfoMap withSpendMode(String spendMode) {
        put(SPEND_MODE, spendMode);
        return this;
    }

    public DayBudgetInfoMap withAmount(Money amount) {
        withAmount(amount.floatValue());
        return this;
    }
}
