package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.common.api45.EmailNotificationInfo;
import ru.yandex.autotests.directapi.model.common.Value;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 25.06.13
 * Time: 11:48
 * To change this template use File | Settings | File Templates.
 */
public class EmailNotificationInfoMap<T> extends ModelBeanMap<EmailNotificationInfoMap> {
    //region this
    private static final String EMAIL_NOTIFICATION_INFO = "EmailNotificationInfo";

    public static final String EMAIL = "email";
    public static final String WARN_PLACE_INTERVAL = "warnPlaceInterval";
    public static final String MONEY_WARNING_VALUE = "moneyWarningValue";
    public static final String SEND_ACC_NEWS = "sendAccNews";
    public static final String SEND_WARN = "sendWarn";
    public static final String PAUSED_BY_DAY_BUDGET = "pausedByDayBudget";


    public EmailNotificationInfoMap(String packageName) {
        super(packageName, EMAIL_NOTIFICATION_INFO);
    }

    public EmailNotificationInfoMap(T emailNotificationInfo) {
        setBean(emailNotificationInfo);
    }
    //endregion

    //region Builder
    public EmailNotificationInfoMap on() {
        withEmail("at-tester@yandex-team.ru")
                .withSendWarn(Value.YES)
                .withWarnPlaceInterval(15)
                .withMoneyWarningValue(10)
                .withSendAccNews(Value.YES);
        return this;
    }

    public EmailNotificationInfoMap withEmail(String notificationEmail) {
        put(EMAIL, notificationEmail);
        return this;
    }

    public EmailNotificationInfoMap withSendWarn(String sendWarn) {
        put(SEND_WARN, sendWarn);
        return this;
    }

    public EmailNotificationInfoMap withWarnPlaceInterval(int warnPlaceInterval) {
        put(WARN_PLACE_INTERVAL, warnPlaceInterval);
        return this;
    }

    public EmailNotificationInfoMap withMoneyWarningValue(Integer moneyWarningValue) {
        put(MONEY_WARNING_VALUE, moneyWarningValue);
        return this;
    }

    public EmailNotificationInfoMap withSendAccNews(String sendAccNews) {
        put(SEND_ACC_NEWS, sendAccNews);
        return this;
    }

    public EmailNotificationInfoMap withPausedByDayBudget(String pausedByDayBudget) {
        put(PAUSED_BY_DAY_BUDGET, pausedByDayBudget);
        return this;
    }
    //endregion
}
