package ru.yandex.autotests.directapi.model.campaigns;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import one.util.streamex.StreamEx;
import org.apache.commons.lang.ArrayUtils;

import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.irt.testutils.RandomUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Цель должна быть активная в активном счетчике не составная:
 * PPCDICT SELECT * FROM metrika_goals mg WHERE mg.goal_id=774871
 */
public class MetrikaGoals {
    private static final ImmutableMap<Integer, List<Long>> goalsByCounter = ImmutableMap.<Integer, List<Long>>builder()
            .put(32265784, ImmutableList.<Long>builder()  //owner: at-campaigns-client; access:  at-camp-update-client
                    .add(13088934L)
                    .add(13088939L)
                    .add(13088944L)
                    .add(13088949L)
                    .build())
            .put(62856098, ImmutableList.<Long>builder()  //owner: at-campaigns-client-features; //todo удалился после переналивки. удалить.
                    .add(104075922L)
                    .add(104075996L)
                    .add(104075923L)
                    .build())
            .put(62927671, ImmutableList.<Long>builder()  //owner: at-campaigns-client-features;
                    .add(104567458L)
                    .add(104567776L)
                    .build())
            .put(62047747, ImmutableList.<Long>builder() //автоматический счетчик для турбостраницы
                    //todo: нужно разделить турбо-цели по признаку "конверсионности". Используется в оплате конверсий..
                    .add(98035325L)
                    .add(98035326L)
                    .build())
            .put(62276813, ImmutableList.<Long>builder() //автоматический счетчик для турбостраницы (metrika-test
                    // .haze.yandex.ru)
                    .add(99450792L) //Нажатие кнопки
                    .add(99450793L) //Нажатие кнопки на товаре
                    .add(99450794L) //Отправка заявки из формы (is_conversion_goal = 1)
                    .add(99450860L) //Добавление товара в корзину (is_conversion_goal = 1)
                    .add(99450862L) //Успешное совершение заказа (is_conversion_goal = 1)
                    .build())
            .put(62265670, ImmutableList.<Long>builder() //автоматический счетчик для турбостраницы (metrika.yandex.ru)
                    .add(99391210L) //Нажатие кнопки
                    .add(99391213L) //Нажатие кнопки на товаре
                    .add(99391216L) //Отправка заявки из формы (is_conversion_goal = 1)
                    .add(99391414L) //Добавление товара в корзину (is_conversion_goal = 1)
                    .add(99391420L) //Успешное совершение заказа (is_conversion_goal = 1)
                    .build())
            .put(34981090, ImmutableList.<Long>builder() //owner: at-camp-update-client
                    .add(17108070L)
                    .add(17108075L)
                    .build())
            .put(88210126, ImmutableList.<Long>builder() //owner: yandex-team-restart-time
                    .add(233220792L)
                    .add(233220797L)
                    .build())
            .put(88209932, ImmutableList.<Long>builder() //owner: at-client-change-strategy
                    .add(233219963L)
                    .build())
            .put(88784712, ImmutableList.<Long>builder() //owner: at-direct-target44
                    .add(236162419L)
                    .build())
            .put(88790353, ImmutableList.<Long>builder() //owner: at-direct-target56
                    .add(236187897L)
                    .build())
            .put(88792196, ImmutableList.<Long>builder() //owner: at-direct-bids-client
                    .add(236195445L)
                    .build())
            .put(88792476, ImmutableList.<Long>builder() //owner: at-client-keywords-add
                    .add(236196600L)
                    .build())
            .put(31844711, ImmutableList.<Long>builder() //owner: at-transport-tester-7
                    .add(18449015L)
                    .build())
            .build();

    //Счетчики доступные логинам
    private static final ImmutableMap<String, List<Integer>> countersByLogin =
            ImmutableMap.<String, List<Integer>>builder()
                    .put("at-campaigns-client", ImmutableList.<Integer>builder()
                            .add(32265784) //owner
                            .add(62047747) //автоматический счетчик для турбостраницы
                            .build())
                    .put("at-campaigns-client-features", ImmutableList.<Integer>builder()
                            .add(62927671) //owner (haze)
                            .build())
                    .put("at-camp-update-client", ImmutableList.<Integer>builder()
                            .add(34981090) //owner
                            .add(32265784) //has access
                            .build())
                    .put("at-turbolanding-client", ImmutableList.<Integer>builder()
                            .add(62047749) //автоматический счетчик для турбостраницы (metrika-test.haze.yandex.ru)
                            .add(62047752) //owner  (metrika-test.haze.yandex.ru)
                            .add(62265670) //автоматический счетчик для турбостраницы (metrika.yandex.ru)
                            .build())
                    .put("yandex-team-restart-time", ImmutableList.<Integer>builder()
                            .add(88210126) //owner
                            .build())
                    .put("at-client-change-strategy", ImmutableList.<Integer>builder()
                            .add(88209932) //owner
                            .build())
                    .put("at-direct-target44", ImmutableList.<Integer>builder()
                            .add(88784712) //owner
                            .build())
                    .put("at-direct-target56", ImmutableList.<Integer>builder()
                            .add(88790353) //owner
                            .build())
                    .put("at-direct-bids-client", ImmutableList.<Integer>builder()
                            .add(88792196) //owner
                            .build())
                    .put("at-client-keywords-add", ImmutableList.<Integer>builder()
                            .add(88792476) //owner
                            .build())
                    .put("at-transport-tester-7", ImmutableList.<Integer>builder()
                            .add(31844711) //owner
                            .build())
                    .build();

    private static int[] goalIDs = {
            5358,    //counterId=46411
            23166,   //counterId=91109
            774871,  //counterId=36477
            11732586 //counterId=31031461
    };
    private static int[] segmentTypeGoalIDs = {
            1000007305,
            1000007300,
            1000007295,
            1000011689
    };
    private static int[] audienceSegmentTypeGoalIDs = {
            2000000450,
            2000000430
    };
    private static Long[] ecommerceTypeGoalIDs = {
            3007735183L,
            3017762959L
    };
    private int counter = 0;

    /*
    Случайная цель из списка
     */
    public static int getRandom() {
        return goalIDs[RandomUtils.getNextInt(goalIDs.length)];
    }

    public static int getRandomSegmentTypeGoal() {
        return segmentTypeGoalIDs[RandomUtils.getNextInt(segmentTypeGoalIDs.length)];
    }

    public static int getRandomAudienceSegmentTypeGoal() {
        return audienceSegmentTypeGoalIDs[RandomUtils.getNextInt(audienceSegmentTypeGoalIDs.length)];
    }

    public static Long getRandomEcommerceTypeGoal() {
        return ecommerceTypeGoalIDs[RandomUtils.getNextInt(ecommerceTypeGoalIDs.length)];
    }

    public static int[] getGoalIDs(int i) {
        if (i < 1 && i > goalIDs.length) {
            throw new DirectUtilsException("Кончились доступные цели");
        }
        MetrikaGoals metrikaGoalIDs = new MetrikaGoals();
        List<Integer> goalIDs = new ArrayList<>();
        for (int j = 0; j < i; j++) {
            goalIDs.add(metrikaGoalIDs.getNext());
        }
        return ArrayUtils.toPrimitive(goalIDs.toArray(new Integer[0]));
    }

    public static Integer getDefaultCounter() {
        return goalsByCounter.keySet().stream().findFirst().orElseThrow(() ->
                new DirectAPIException("Ошибка при получении тестового счетчика"));
    }

    public static Integer getCounterForLogin(String login) {
        return countersByLogin.getOrDefault(login, Collections.emptyList()).stream().findFirst()
                .orElseThrow(() -> new DirectAPIException("Не найден счетчик для логина " + login));
    }

    public static Long getGoalForLogin(String login) {
        return getGoalsForLogin(login, 1).get(0);
    }

    public static List<Long> getGoalsForLogin(String login, int size) {
        List<Integer> counters = countersByLogin.getOrDefault(login, Collections.emptyList());
        for (Integer counter : counters) {
            List<Long> goals = goalsByCounter.get(counter);
            if (goals.size() >= size) {
                return goals.subList(0, size);
            }
        }
        throw new DirectAPIException(String.format("Не найдено %d целей для логина %s", size, login));
    }

    public static Long[] getConterGoalIds(Integer counterId, int numOfGoals) {
        List<Long> goals = goalsByCounter.get(counterId);
        if (goals.size() < numOfGoals) {
            throw new DirectAPIException("Недостаточное количество целей у счетчика");
        }
        return StreamEx.of(goals).limit(numOfGoals).toList().toArray(new Long[numOfGoals]);
    }

    public static Long getGoalForCounter(Integer counterId) {
        return goalsByCounter.getOrDefault(counterId, Collections.emptyList())
                .stream().findAny().orElseThrow(() -> new DirectAPIException("Не найдены цели для счетчика " + counterId));
    }

    public static String getGoalType(long goalId) {
        if (goalId < 0) {
            return null;
        } else if (goalId < 1000000000L) {
            return RetargetingGoalType.GOAL.toString();
        } else if (goalId < 2000000000L) {
            return RetargetingGoalType.SEGMENT.toString();
        } else if (goalId < 3000000000L) {
            return RetargetingGoalType.AUDIENCE_SEGMENT.toString();
        }
        return RetargetingGoalType.GOAL.toString();
    }

    /*
    Метод берет цели по порядку.
    Нужен, если необходимо, чтобы цели не повторялись.
     */
    public int getNext() {
        if (counter >= goalIDs.length) {
            throw new DirectUtilsException("Кончились доступные цели");
        }
        int goalID = goalIDs[counter];
        counter++;
        return goalID;
    }

}
