package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.common.api4.SmsNotificationInfo;
import ru.yandex.autotests.directapi.model.common.Value;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 25.06.13
 * Time: 11:48
 * To change this template use File | Settings | File Templates.
 */
public class SmsNotificationInfoMap<T> extends ModelBeanMap<SmsNotificationInfoMap> {
    //region this
    private static final String SMS_NOTIFICATION_INFO = "SmsNotificationInfo";
    public static final String MONEY_OUT_SMS = "moneyOutSms";
    public static final String MONEY_IN_SMS = "moneyInSms";
    public static final String MODERATE_RESULT_SMS = "moderateResultSms";
    public static final String METRICA_SMS = "metricaSms";
    public static final String SMS_TIME_FROM = "smsTimeFrom";
    public static final String SMS_TIME_TO = "smsTimeTo";
    public static final String PAUSED_BY_DAY_BUDGET_SMS = "pausedByDayBudgetSms";


    public SmsNotificationInfoMap(String packageName) {
        super(packageName, SMS_NOTIFICATION_INFO);
    }

    public SmsNotificationInfoMap(T smsNotificationInfo) {
        super();
        setBean(smsNotificationInfo);
    }
    //endregion

    //region Builder
    public SmsNotificationInfoMap on() {
        this.put((MONEY_OUT_SMS), Value.NO);
        this.put((MONEY_IN_SMS), Value.NO);
        this.put((MODERATE_RESULT_SMS), Value.NO);
        this.put((METRICA_SMS), Value.NO);
        this.put((SMS_TIME_FROM), "12:00");
        this.put((SMS_TIME_TO), "15:00");
        return this;
    }

    public SmsNotificationInfoMap withMoneyInSms(String value) {
        this.put((MONEY_IN_SMS), value);
        return this;

    }

    public SmsNotificationInfoMap withMoneyOutSms(String value) {
        this.put((MONEY_OUT_SMS), value);
        return this;
    }

    public SmsNotificationInfoMap withSmsTimeTo(String smsTimeTo) {
        this.put(SMS_TIME_TO, smsTimeTo);
        return this;
    }

    public SmsNotificationInfoMap withSmsTimeFrom(String smsTimeFrom) {
        this.put(SMS_TIME_FROM, smsTimeFrom);
        return this;
    }

    public SmsNotificationInfoMap withMetricaSms(String metricaSms) {
        this.put(METRICA_SMS, metricaSms);
        return this;
    }

    public SmsNotificationInfoMap withModerateResultSms(String moderateResultSms) {
        this.put(MODERATE_RESULT_SMS, moderateResultSms);
        return this;
    }
    public SmsNotificationInfoMap withPausedByDayBudgetSms(String pausedByDayBudgetSms) {
        this.put(PAUSED_BY_DAY_BUDGET_SMS, pausedByDayBudgetSms);
        return this;
    }
    //endregion
}
