package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Money;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 24.06.13
 * Time: 22:24
 * To change this template use File | Settings | File Templates.
 */
public class StrategyMap<T> extends ModelBeanMap<StrategyMap> {
    //region Fields
    private static final String CAMPAIGN_STRATEGY = "CampaignStrategy";
    private static final String CAMPAIGN_CONTEXT_STRATEGY = "CampaignContextStrategy";

    public static final String STRATEGY_NAME = "strategyName";
    public static final String MAX_PRICE = "maxPrice";
    public static final String AVERAGE_PRICE = "averagePrice";
    public static final String WEEKLY_SUM_LIMIT = "weeklySumLimit";
    public static final String CLICKS_PER_WEEK = "clicksPerWeek";
    public static final String GOAL_ID = "goalID";
    public static final String AVERAGE_CPA = "averageCPA";
    public static final String CONTEXT_LIMIT = "contextLimit";
    public static final String CONTEXT_LIMIT_SUM = "contextLimitSum";
    public static final String CONTEXT_PRICE_PERCENT = "contextPricePercent";
    public static final String RESERVE_RETURN = "reserveReturn";
    public static final String ROI_COEF = "ROICoef";
    public static final String PROFITABILITY = "profitability";

    public String getStrategyName() {
        return (String) this.get(STRATEGY_NAME);
    }


    //endregion
    public enum StrategyType {
        SEARCH,
        CONTEXT
    }

    public StrategyMap(String packageName, StrategyType strategyType) {
        super();
        if (strategyType.equals(StrategyType.SEARCH)) {
            setBean(ReflectionUtils.getInstance(packageName, CAMPAIGN_STRATEGY));
        } else {
            setBean(ReflectionUtils.getInstance(packageName, CAMPAIGN_CONTEXT_STRATEGY));
        }
    }

    @Deprecated
    public StrategyMap(T strategyObject) {
        super();
        setBean(strategyObject);
    }

    //region field possible values
    public final class StrategyName {
        public final static String AVERAGE_CLICK_PRICE = "AverageClickPrice";
        public final static String HIGHEST_POSITION = "HighestPosition";
        public final static String LOWEST_COST_PREMIUM = "LowestCostPremium";
        public final static String LOWEST_COST = "LowestCost";
        public final static String WEEKLY_BUDGET = "WeeklyBudget";
        public final static String WEEKLY_PACKET_OF_CLICKS = "WeeklyPacketOfClicks";
        public final static String NO_PREMIUM_POSITION = "NoPremiumPosition";
        public final static String INDEPENDENT_CONTROL = "IndependentControl";
        public final static String RIGHT_BLOCK_HIGHEST = "RightBlockHighest";
        public final static String LOWEST_COST_GUARANTEE = "LowestCostGuarantee";
        public final static String CPA_OPTIMIZER = "CPAOptimizer";
        public final static String DEFAULT = "Default";
        public final static String LIMITED = "Limited";
        public final static String MAXIMUM_COVERAGE = "MaximumCoverage";
        public final static String SHOWS_DISABLED = "ShowsDisabled";
        //    public final static String STRETCHED ="Stretched";
        public final static String AVERAGE_CPA_OPTIMIZATION = "AverageCPAOptimization";
        public final static String ROI_OPTIMIZATION = "ROIOptimization";


    }
    //endregion

    //region Builder
    public StrategyMap withStrategy(String strategyName) {
        put(STRATEGY_NAME, strategyName);
        return this;
    }

    public StrategyMap withMaxPrice(Float maxPrice) {
        put(MAX_PRICE, maxPrice);
        return this;
    }

    public StrategyMap withMaxPrice(Money maxPrice) {
        if (maxPrice != null) {
            put(MAX_PRICE, maxPrice.floatValue());
        } else {
            put(MAX_PRICE, maxPrice);
        }
        return this;
    }


    public StrategyMap withAveragePrice(Float averagePrice) {
        put(AVERAGE_PRICE, averagePrice);
        return this;
    }

    public StrategyMap withAveragePrice(Money averagePrice) {
        if (averagePrice != null) {
            put(AVERAGE_PRICE, averagePrice.floatValue());
        } else {
            put(AVERAGE_PRICE, averagePrice);
        }
        return this;
    }

    public StrategyMap withWeeklySumLimit(Float weeklySumLimit) {
        put(WEEKLY_SUM_LIMIT, weeklySumLimit);
        return this;
    }

    public StrategyMap withWeeklySumLimit(Money weeklySumLimit) {
        if (weeklySumLimit != null) {
            put(WEEKLY_SUM_LIMIT, weeklySumLimit.floatValue());
        } else {
            put(WEEKLY_SUM_LIMIT, weeklySumLimit);
        }
        return this;
    }

    public StrategyMap withClicksPerWeek(Integer clicksPerWeek) {
        put(CLICKS_PER_WEEK, clicksPerWeek);
        return this;
    }

    public StrategyMap withGoalID(Integer goalID) {
        put(GOAL_ID, goalID);
        return this;
    }

    public StrategyMap withContextLimit(String contextLimit) {
        put(CONTEXT_LIMIT, contextLimit);
        return this;
    }

    public StrategyMap withContextLimitSum(Integer contextLimitSum) {
        put(CONTEXT_LIMIT_SUM, contextLimitSum);
        return this;
    }

    public StrategyMap withContextPricePercent(Integer contextPricePercent) {
        put(CONTEXT_PRICE_PERCENT, contextPricePercent);
        return this;
    }


    public StrategyMap withAverageCPA(Float averageCPA) {
        put(AVERAGE_CPA, averageCPA);
        return this;
    }

    public StrategyMap withAverageCPA(Money averageCPA) {
        if (averageCPA != null) {
            put(AVERAGE_CPA, averageCPA.floatValue());
        } else {
            put(AVERAGE_CPA, averageCPA);
        }
        return this;
    }

    public StrategyMap withReserveReturn(Integer reserveReturn) {
        put(RESERVE_RETURN, reserveReturn);
        return this;
    }

    public StrategyMap withROICoef(Float roiCoef) {
        put(ROI_COEF, roiCoef);
        return this;
    }

    public StrategyMap withProfitability(Float profitability) {
        put(PROFITABILITY, profitability);
        return this;
    }

    //region Default strategies
    public StrategyMap highestPosition() {
        this.clear();
        return this
                .withStrategy(StrategyName.HIGHEST_POSITION);
    }

    public StrategyMap lowestCost() {
        this.clear();
        return this
                .withStrategy(StrategyName.LOWEST_COST);
    }

    public StrategyMap lowestCostPremium() {
        this.clear();
        return this
                .withStrategy(StrategyName.LOWEST_COST_PREMIUM);
    }

    public StrategyMap lowestCostGuarantee() {
        this.clear();
        return this
                .withStrategy(StrategyName.LOWEST_COST_GUARANTEE);
    }

    public StrategyMap rightBlockHighest() {
        this.clear();
        return this
                .withStrategy(StrategyName.RIGHT_BLOCK_HIGHEST);
    }

    public StrategyMap noPremiumPosition() {
        this.clear();
        return this
                .withStrategy(StrategyName.NO_PREMIUM_POSITION);
    }

    public StrategyMap independentControl() {
        this.clear();
        return this
                .withStrategy(StrategyName.INDEPENDENT_CONTROL);
    }

    public StrategyMap averageClickPrice() {
        this.clear();
        return this
                .withStrategy(StrategyName.AVERAGE_CLICK_PRICE)
                .withAveragePrice(5f);
    }

    public StrategyMap cpaOptimizer() {
        return cpaOptimizer(0);
    }

    public StrategyMap cpaOptimizer(int goalID) {
        this.clear();
        return this
                .withStrategy(StrategyName.CPA_OPTIMIZER)
                .withGoalID(goalID)
                .withWeeklySumLimit(300f);
    }

    public StrategyMap averageCpaOptimizer(int goalID) {
        this.clear();
        return this
                .withStrategy(StrategyName.AVERAGE_CPA_OPTIMIZATION)
                .withGoalID(goalID)
                .withAverageCPA(300f);
    }

    public StrategyMap showsDisabled() {
        this.clear();
        return this
                .withStrategy(StrategyName.SHOWS_DISABLED);
    }

    public StrategyMap weeklyBudget() {
        return this.weeklyBudget(500.0f);
    }

    public StrategyMap weeklyBudget(float weeklySumLimit) {
        this.clear();
        return this
                .withStrategy(StrategyName.WEEKLY_BUDGET)
                .withWeeklySumLimit(weeklySumLimit);
    }


    public StrategyMap weeklyPacketOfClicks() {
        return this.weeklyPacketOfClicks(100, null, null);
    }

    public StrategyMap weeklyPacketOfClicks(int clicksPerWeek, Float maxPrice, Float averagePrice) {
        this.clear();
        return this
                .withStrategy(StrategyName.WEEKLY_PACKET_OF_CLICKS)
                .withClicksPerWeek(clicksPerWeek)
                .withMaxPrice(maxPrice)
                .withAveragePrice(averagePrice);
    }

    public StrategyMap maximumCoverage() {
        this.clear();
        return this
                .withStrategy(StrategyName.MAXIMUM_COVERAGE);
    }

    /**
     * Default context strategy.
     * By default ContextLimit(Sum), ContextPricePersent = null
     *
     * @return StrategyMap - BeanMap with default parameters for default context strategy
     */
    public StrategyMap defaultStrategy() {
        this.clear();
        return this
                .withStrategy(StrategyName.DEFAULT);
    }

    public StrategyMap roiOptimization(Integer reserveReturn, Float roiCoef, Integer goalID) {
        this.clear();
        return this
                .withStrategy(StrategyName.ROI_OPTIMIZATION)
                .withReserveReturn(reserveReturn)
                .withROICoef(roiCoef)
                .withGoalID(goalID);
    }
    //endregion

    //endregion

}
