package ru.yandex.autotests.directapi.model.campaigns;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static org.apache.commons.lang.StringUtils.uncapitalize;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 02.12.13
 * Time: 18:48
 * To change this template use File | Settings | File Templates.
 */
public class TimeTargetItemMap<T> extends ModelBeanMap<TimeTargetItemMap> {

    private static final String TIME_TARGET_ITEM = "TimeTargetItem";

    public static final String DAYS = "days";
    public static final String HOURS = "hours";
    public static final String BID_COEFS = "bidCoefs";

    public static final int BID_COEF_MAX_VALUE = 200;
    public static final int BID_COEF_MIN_VALUE = 0;


    public TimeTargetItemMap(String packageName) {
        super(packageName, TIME_TARGET_ITEM);
    }

    public TimeTargetItemMap(T timeTargetItem) {
        super();
        setBean(timeTargetItem);
    }

    public TimeTargetItemMap withDays(int... days) {
        this.put(uncapitalize(DAYS), days);
        return this;
    }

    public TimeTargetItemMap withHours(int... hours) {
        this.put(uncapitalize(HOURS), hours);
        return this;
    }

    public TimeTargetItemMap withBidCoefs(int... bidCoefs) {
        this.put(uncapitalize(BID_COEFS), bidCoefs);
        return this;
    }

    public TimeTargetItemMap daily() {
        this.withDays(1, 2, 3, 4, 5, 6, 7);
        return this;
    }

    public TimeTargetItemMap hourly() {
        this.withHours(
                0, 1, 2, 3, 4, 5, 6, 7,
                8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
                18, 19, 20, 21, 22, 23);
        return this;
    }

    public TimeTargetItemMap noLimit() {
        this.withBidCoefs(
                100, 100, 100, 100, 100, 100, 100, 100,
                100, 100, 100, 100, 100, 100, 100, 100,
                100, 100, 100, 100, 100, 100, 100, 100
        );
        return this;
    }

    public TimeTargetItemMap noBidCoefs() {
        clear();
        return this
                .daily()
                .hourly();
    }

    public TimeTargetItemMap bidCoefs() {
        clear();
        return this
                .daily()
                .hourly()
                .noLimit();
    }
}
