package ru.yandex.autotests.directapi.model.campaigns;

import java.lang.reflect.Array;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.common.Value;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 24.06.13
 * Time: 22:41
 * To change this template use File | Settings | File Templates.
 */
public class TimeTargetMap<T> extends ModelBeanMap<TimeTargetMap> {
    //region this
    private static final String TIME_TARGET_INFO = "TimeTargetInfo";

    public static final String SHOW_ON_HOLIDAYS = "showOnHolidays";
    public static final String HOLIDAY_SHOW_FROM = "holidayShowFrom";
    public static final String HOLIDAY_SHOW_TO = "holidayShowTo";
    public static final String DAYS_HOURS = "daysHours";
    public static final String TIME_ZONE = "timeZone";
    public static final String WORKING_HOLIDAYS = "workingHolidays";

    //endregion

    public TimeTargetMap(String packageName) {
        super(packageName, TIME_TARGET_INFO);
    }

    public TimeTargetMap(T timeTarget) {
        super();
        setBean(timeTarget);
    }

    public final class TimeZone {
        public final static String AMERICA_DENVER = "America/Denver";
        public final static String AMERICA_JUNEAU = "America/Juneau";
        public final static String AMERICA_KENTUCKY_MONTICELLO = "America/Kentucky/Monticello";
        public final static String AMERICA_LOS_ANGELES = "America/Los_Angeles";
        public final static String AMERICA_LOUISVILLE = "America/Louisville";
        public final static String AMERICA_NORTH_DAKOTA_CENTER = "America/North_Dakota/Center";
        public final static String PACIFIC_HONOLULU = "Pacific/Honolulu";
        public final static String AMERICA_ARGENTINA_BUENOS_AIRES = "America/Argentina/Buenos_Aires";
        public final static String AMERICA_MACEIO = "America/Maceio";
        public final static String AMERICA_MANAUS = "America/Manaus";
        public final static String AMERICA_SAO_PAULO = "America/Sao_Paulo";
        public final static String AMERICA_HALIFAX = "America/Halifax";
        public final static String AMERICA_MIQUELON = "America/Miquelon";
        public final static String AMERICA_SWIFT_CURRENT = "America/Swift_Current";
        public final static String AMERICA_TORONTO = "America/Toronto";
        public final static String AMERICA_VANCOUVER = "America/Vancouver";
        public final static String AMERICA_WINNIPEG = "America/Winnipeg";
        public final static String AMERICA_YELLOWKNIFE = "America/Yellowknife";
        public final static String EUROPE_BERLIN = "Europe/Berlin";
        public final static String EUROPE_LONDON = "Europe/London";
        public final static String EUROPE_VIENNA = "Europe/Vienna";
        public final static String EUROPE_BRUSSELS = "Europe/Brussels";
        public final static String EUROPE_SOFIA = "Europe/Sofia";
        public final static String EUROPE_BUDAPEST = "Europe/Budapest";
        public final static String EUROPE_VILNIUS = "Europe/Vilnius";
        public final static String EUROPE_AMSTERDAM = "Europe/Amsterdam";
        public final static String EUROPE_OSLO = "Europe/Oslo";
        public final static String EUROPE_WARSAW = "Europe/Warsaw";
        public final static String EUROPE_BRATISLAVA = "Europe/Bratislava";
        public final static String EUROPE_LJUBLJANA = "Europe/Ljubljana";
        public final static String EUROPE_HELSINKI = "Europe/Helsinki";
        public final static String EUROPE_PARIS = "Europe/Paris";
        public final static String EUROPE_PRAGUE = "Europe/Prague";
        public final static String EUROPE_ZURICH = "Europe/Zurich";
        public final static String EUROPE_STOCKHOLM = "Europe/Stockholm";
        public final static String ASIA_URUMQI = "Asia/Urumqi";
        public final static String ASIA_SEOUL = "Asia/Seoul";
        public final static String ASIA_TOKYO = "Asia/Tokyo";
        public final static String PACIFIC_AUCKLAND = "Pacific/Auckland";
        public final static String EUROPE_MINSK = "Europe/Minsk";
        public final static String ASIA_ALMATY = "Asia/Almaty";
        public final static String ASIA_AQTOBE = "Asia/Aqtobe";
        public final static String ASIA_BAKU = "Asia/Baku";
        public final static String ASIA_YEREVAN = "Asia/Yerevan";
        public final static String ASIA_TBILISI = "Asia/Tbilisi";
        public final static String ASIA_ASHGABAT = "Asia/Ashgabat";
        public final static String ASIA_TASHKENT = "Asia/Tashkent";
        public final static String EUROPE_TALLINN = "Europe/Tallinn";
        public final static String ASIA_JERUSALEM = "Asia/Jerusalem";
        public final static String ATLANTIC_FAEROE = "Atlantic/Faeroe";
        public final static String EUROPE_COPENHAGEN = "Europe/Copenhagen";
        public final static String ATLANTIC_CANARY = "Atlantic/Canary";
        public final static String EUROPE_MADRID = "Europe/Madrid";
        public final static String EUROPE_RIGA = "Europe/Riga";
        public final static String ASIA_BISHKEK = "Asia/Bishkek";
        public final static String EUROPE_KIEV = "Europe/Kiev";
        public final static String ASIA_DUSHANBE = "Asia/Dushanbe";
        public final static String ASIA_DUBAI = "Asia/Dubai";
        public final static String AUSTRALIA_BRISBANE = "Australia/Brisbane";
        public final static String AUSTRALIA_PERTH = "Australia/Perth";
        public final static String AUSTRALIA_SYDNEY = "Australia/Sydney";
        public final static String ASIA_IRKUTSK = "Asia/Irkutsk";
        public final static String ASIA_KAMCHATKA = "Asia/Kamchatka";
        public final static String ASIA_KRASNOYARSK = "Asia/Krasnoyarsk";
        public final static String ASIA_OMSK = "Asia/Omsk";
        public final static String ASIA_SREDNEKOLYMSK = "Asia/Srednekolymsk";
        public final static String ASIA_VLADIVOSTOK = "Asia/Vladivostok";
        public final static String ASIA_YAKUTSK = "Asia/Yakutsk";
        public final static String ASIA_YEKATERINBURG = "Asia/Yekaterinburg";
        public final static String EUROPE_KALININGRAD = "Europe/Kaliningrad";
        public final static String EUROPE_SAMARA = "Europe/Samara";
        public final static String EUROPE_ATHENS = "Europe/Athens";
        public final static String EUROPE_ISTANBUL = "Europe/Istanbul";
        public final static String ASIA_BANGKOK = "Asia/Bangkok";
        public final static String AFRICA_CAIRO = "Africa/Cairo";
        public final static String AMERICA_JAMAICA = "America/Jamaica";
        public final static String AMERICA_LA_PAZ = "America/La_Paz";
        public final static String AMERICA_HAVANA = "America/Havana";
        public final static String AFRICA_CASABLANCA = "Africa/Casablanca";
        public final static String AFRICA_JOHANNESBURG = "Africa/Johannesburg";
        public final static String AFRICA_TRIPOLI = "Africa/Tripoli";
        public final static String AFRICA_TUNIS = "Africa/Tunis";
        public final static String PACIFIC_FIJI = "Pacific/Fiji";
        public final static String EUROPE_TIRANE = "Europe/Tirane";
        public final static String EUROPE_SARAJEVO = "Europe/Sarajevo";
        public final static String EUROPE_DUBLIN = "Europe/Dublin";
        public final static String ATLANTIC_REYKJAVIK = "Atlantic/Reykjavik";
        public final static String EUROPE_VADUZ = "Europe/Vaduz";
        public final static String EUROPE_SKOPJE = "Europe/Skopje";
        public final static String EUROPE_MALTA = "Europe/Malta";
        public final static String EUROPE_MONACO = "Europe/Monaco";
        public final static String ATLANTIC_AZORES = "Atlantic/Azores";
        public final static String EUROPE_LISBON = "Europe/Lisbon";
        public final static String EUROPE_ROME = "Europe/Rome";
        public final static String EUROPE_BUCHAREST = "Europe/Bucharest";
        public final static String EUROPE_ZAGREB = "Europe/Zagreb";
        public final static String EUROPE_ANDORRA = "Europe/Andorra";
        public final static String EUROPE_GIBRALTAR = "Europe/Gibraltar";
        public final static String ASIA_DHAKA = "Asia/Dhaka";
        public final static String ASIA_JAKARTA = "Asia/Jakarta";
        public final static String ASIA_JAYAPURA = "Asia/Jayapura";
        public final static String ASIA_MAKASSAR = "Asia/Makassar";
        public final static String ASIA_KUALA_LUMPUR = "Asia/Kuala_Lumpur";
        public final static String INDIAN_MALDIVES = "Indian/Maldives";
        public final static String ASIA_HOVD = "Asia/Hovd";
        public final static String ASIA_ULAANBAATAR = "Asia/Ulaanbaatar";
        public final static String ASIA_KARACHI = "Asia/Karachi";
        public final static String ASIA_PYONGYANG = "Asia/Pyongyang";
        public final static String ASIA_SINGAPORE = "Asia/Singapore";
        public final static String ASIA_MANILA = "Asia/Manila";
        public final static String ASIA_AMMAN = "Asia/Amman";
        public final static String ASIA_KUWAIT = "Asia/Kuwait";
        public final static String ASIA_BEIRUT = "Asia/Beirut";
        public final static String ASIA_RIYADH = "Asia/Riyadh";
        public final static String ASIA_DAMASCUS = "Asia/Damascus";
        public final static String AMERICA_CHIHUAHUA = "America/Chihuahua";
        public final static String AMERICA_HERMOSILLO = "America/Hermosillo";
        public final static String AMERICA_MEXICO_CITY = "America/Mexico_City";
        public final static String AMERICA_TIJUANA = "America/Tijuana";
        public final static String ASIA_BRUNEI = "Asia/Brunei";
        public final static String ASIA_BAGHDAD = "Asia/Baghdad";
        public final static String ASIA_NICOSIA = "Asia/Nicosia";
        public final static String AFRICA_ABIDJAN = "Africa/Abidjan";
        public final static String AFRICA_DOUALA = "Africa/Douala";
        public final static String PACIFIC_PORT_MORESBY = "Pacific/Port_Moresby";
        public final static String AFRICA_LAGOS = "Africa/Lagos";
        public final static String PACIFIC_GUAM = "Pacific/Guam";
        public final static String AMERICA_ST_VINCENT = "America/St_Vincent";
        public final static String AMERICA_PUERTO_RICO = "America/Puerto_Rico";
        public final static String AFRICA_ADDIS_ABABA = "Africa/Addis_Ababa";
        public final static String AFRICA_EL_AAIUN = "Africa/El_Aaiun";
        public final static String EUROPE_SAN_MARINO = "Europe/San_Marino";
        public final static String AFRICA_ACCRA = "Africa/Accra";
        public final static String AFRICA_CONAKRY = "Africa/Conakry";
        public final static String AFRICA_ALGIERS = "Africa/Algiers";
        public final static String INDIAN_ANTANANARIVO = "Indian/Antananarivo";
        public final static String AMERICA_ANTIGUA = "America/Antigua";
        public final static String PACIFIC_APIA = "Pacific/Apia";
        public final static String PACIFIC_EASTER = "Pacific/Easter";
        public final static String AFRICA_PORTO_NOVO = "Africa/Porto-Novo";
        public final static String AMERICA_SANTO_DOMINGO = "America/Santo_Domingo";
        public final static String AFRICA_HARARE = "Africa/Harare";
        public final static String AMERICA_GUATEMALA = "America/Guatemala";
        public final static String ASIA_VIENTIANE = "Asia/Vientiane";
        public final static String ASIA_PHNOM_PENH = "Asia/Phnom_Penh";
        public final static String AFRICA_ASMERA = "Africa/Asmera";
        public final static String AMERICA_ASUNCION = "America/Asuncion";
        public final static String AFRICA_BANGUI = "Africa/Bangui";
        public final static String AFRICA_BANJUL = "Africa/Banjul";
        public final static String AMERICA_BARBADOS = "America/Barbados";
        public final static String AMERICA_ST_KITTS = "America/St_Kitts";
        public final static String AFRICA_MALABO = "Africa/Malabo";
        public final static String AMERICA_COSTA_RICA = "America/Costa_Rica";
        public final static String AFRICA_LIBREVILLE = "Africa/Libreville";
        public final static String AFRICA_BISSAU = "Africa/Bissau";
        public final static String AFRICA_BAMAKO = "Africa/Bamako";
        public final static String AFRICA_LOME = "Africa/Lome";
        public final static String AMERICA_TEGUCIGALPA = "America/Tegucigalpa";
        public final static String AFRICA_KINSHASA = "Africa/Kinshasa";
        public final static String AMERICA_PORT_OF_SPAIN = "America/Port_of_Spain";
        public final static String AMERICA_BOGOTA = "America/Bogota";
        public final static String AFRICA_LUSAKA = "Africa/Lusaka";
        public final static String AFRICA_BRAZZAVILLE = "Africa/Brazzaville";
        public final static String AFRICA_SAO_TOME = "Africa/Sao_Tome";
        public final static String EUROPE_LUXEMBOURG = "Europe/Luxembourg";
        public final static String AFRICA_DAR_ES_SALAAM = "Africa/Dar_es_Salaam";
        public final static String AFRICA_BUJUMBURA = "Africa/Bujumbura";
        public final static String AFRICA_WINDHOEK = "Africa/Windhoek";
        public final static String AFRICA_FREETOWN = "Africa/Freetown";
        public final static String AFRICA_NAIROBI = "Africa/Nairobi";
        public final static String AFRICA_MOGADISHU = "Africa/Mogadishu";
        public final static String AFRICA_KAMPALA = "Africa/Kampala";
        public final static String AMERICA_MANAGUA = "America/Managua";
        public final static String AFRICA_MAPUTO = "Africa/Maputo";
        public final static String AFRICA_GABORONE = "Africa/Gaborone";
        public final static String INDIAN_MAURITIUS = "Indian/Mauritius";
        public final static String AFRICA_MBABANE = "Africa/Mbabane";
        public final static String AFRICA_MASERU = "Africa/Maseru";
        public final static String AFRICA_MONROVIA = "Africa/Monrovia";
        public final static String AMERICA_MONTEVIDEO = "America/Montevideo";
        public final static String INDIAN_COMORO = "Indian/Comoro";
        public final static String AMERICA_LIMA = "America/Lima";
        public final static String AMERICA_PORT_AU_PRINCE = "America/Port-au-Prince";
        public final static String AMERICA_NASSAU = "America/Nassau";
        public final static String ATLANTIC_CAPE_VERDE = "Atlantic/Cape_Verde";
        public final static String PACIFIC_TAHITI = "Pacific/Tahiti";
        public final static String AFRICA_NDJAMENA = "Africa/Ndjamena";
        public final static String AFRICA_NIAMEY = "Africa/Niamey";
        public final static String AFRICA_NOUAKCHOTT = "Africa/Nouakchott";
        public final static String EUROPE_VATICAN = "Europe/Vatican";
        public final static String AFRICA_KIGALI = "Africa/Kigali";
        public final static String AMERICA_GRENADA = "America/Grenada";
        public final static String AFRICA_DAKAR = "Africa/Dakar";
        public final static String AMERICA_CAYENNE = "America/Cayenne";
        public final static String AFRICA_DJIBOUTI = "Africa/Djibouti";
        public final static String AMERICA_GUYANA = "America/Guyana";
        public final static String ASIA_BAHRAIN = "Asia/Bahrain";
        public final static String AMERICA_ANGUILLA = "America/Anguilla";
        public final static String AMERICA_ARUBA = "America/Aruba";
        public final static String AMERICA_BELIZE = "America/Belize";
        public final static String ATLANTIC_BERMUDA = "Atlantic/Bermuda";
        public final static String ASIA_THIMPHU = "Asia/Thimphu";
        public final static String ASIA_ADEN = "Asia/Aden";
        public final static String AMERICA_ST_THOMAS = "America/St_Thomas";
        public final static String PACIFIC_EFATE = "Pacific/Efate";
        public final static String AMERICA_TORTOLA = "America/Tortola";
        public final static String ASIA_DILI = "Asia/Dili";
        public final static String AMERICA_GODTHAB = "America/Godthab";
        public final static String AMERICA_CAYMAN = "America/Cayman";
        public final static String PACIFIC_TARAWA = "Pacific/Tarawa";
        public final static String PACIFIC_RAROTONGA = "Pacific/Rarotonga";
        public final static String PACIFIC_MAJURO = "Pacific/Majuro";
        public final static String PACIFIC_YAP = "Pacific/Yap";
        public final static String PACIFIC_NAURU = "Pacific/Nauru";
        public final static String PACIFIC_NOUMEA = "Pacific/Noumea";
        public final static String ASIA_MUSCAT = "Asia/Muscat";
        public final static String PACIFIC_PALAU = "Pacific/Palau";
        public final static String AMERICA_GRAND_TURK = "America/Grand_Turk";
        public final static String PACIFIC_TONGATAPU = "Pacific/Tongatapu";
        public final static String PACIFIC_FUNAFUTI = "Pacific/Funafuti";
        public final static String EUROPE_BELGRADE = "Europe/Belgrade";
        public final static String ASIA_SHANGHAI = "Asia/Shanghai";
        public final static String EUROPE_MOSCOW = "Europe/Moscow";
        public final static String AMERICA_MONTSERRAT = "America/Montserrat";
        public final static String AUSTRALIA_MELBOURNE = "Australia/Melbourne";
        public final static String PACIFIC_NIUE = "Pacific/Niue";
        public final static String ASIA_GAZA = "Asia/Gaza";
        public final static String AMERICA_SANTIAGO = "America/Santiago";
        public final static String AMERICA_DOMINICA = "America/Dominica";
        public final static String AFRICA_KHARTOUM = "Africa/Khartoum";
        public final static String AMERICA_CURACAO = "America/Curacao";
    }

    //region Builder
    public TimeTargetMap withShowOnHolidays(
            String showOnHolidays,
            Integer showFrom,
            Integer showTo)
    {
        this.put((SHOW_ON_HOLIDAYS), showOnHolidays);
        this.put((HOLIDAY_SHOW_FROM), showFrom);
        this.put((HOLIDAY_SHOW_TO), showTo);
        return this;
    }

    public TimeTargetMap withTimeZone(String timeZone) {
        this.put((TIME_ZONE), timeZone);
        return this;
    }

    public TimeTargetMap withWorkingHolidays(String yesNoValue) {
        this.put((WORKING_HOLIDAYS), yesNoValue);
        return this;
    }

    public TimeTargetMap withDayHour(TimeTargetItemMap... daysHours) {
        if (daysHours != null) {
            this.put((DAYS_HOURS),
                    convert(daysHours, new BeanMapToBeanConverter())
                            .toArray((Object[]) Array.newInstance(new TimeTargetItemMap(super.getPackageName())
                                    .getBean().getClass(), 0)));
        } else {
            this.put((DAYS_HOURS), null);
        }
        return this;
    }

    public TimeTargetMap noCoefs() {
        return this
                .withShowOnHolidays(Value.YES, 9, 17)
                .withTimeZone(TimeZone.EUROPE_MOSCOW)
                .withDayHour(new TimeTargetItemMap(super.getPackageName()).noBidCoefs()
                );
    }

    public TimeTargetMap withCoefs() {
        return this
                .withShowOnHolidays(Value.YES, 9, 17)
                .withTimeZone(TimeZone.EUROPE_MOSCOW)
                .withWorkingHolidays(Value.NO)
                .withDayHour(new TimeTargetItemMap(super.getPackageName()).bidCoefs()
                );
    }
    //endregion
}
