package ru.yandex.autotests.directapi.model.clients;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.common.Value;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: omaz
 * Date: 06.09.13
 * Time: 15:14
 * To change this template use File | Settings | File Templates.
 */
public class ClientInfoMap<T> extends ModelBeanMap<ClientInfoMap> {
    private static final String CLIENT_INFO = "ClientInfo";

    public static final String PHONE = "phone";
    public static final String DATE_CREATE = "dateCreate";
    public static final String FIO = "FIO";
    public static final String EMAIL = "email";
    public static final String LOGIN = "login";
    public static final String STATUS_ARCH = "statusArch";
    public static final String DISCOUNT = "discount";
    public static final String OVERDRAFT_SUM_AVAILABLE = "overdraftSumAvailable";
    public static final String OVERDRAFT_SUM_AVAILABLE_IN_CURRENCY = "overdraftSumAvailableInCurrency";
    public static final String CURRENCY = "currency";
    public static final String VATRATE = "VATRate";
    public static final String CLIENT_CURRENCIES = "clientCurrencies";
    public static final String SMS_PHONE = "smsPhone";
    public static final String CAMPAIGN_EMAILS = "campaignEmails";
    public static final String CLIENT_RIGHTS = "clientRights";
    public static final String ROLE = "role";
    public static final String NON_RESIDENT = "nonResident";
    public static final String SEND_NEWS = "sendNews";
    public static final String SEND_ACC_NEWS = "sendAccNews";
    public static final String SEND_WARN = "sendWarn";
    public static final String MANAGER_LOGINS = "managersLogins";
    public static final String SHARED_ACCOUNT_ENABLED = "sharedAccountEnabled";
    public static final String AGENCY_NAME = "agencyName";
    public static final String AGENCY_URL = "agencyUrl";
    public static final String AGENCY_STATUS = "agencyStatus";
    public static final String SEND_AGENCY_MCB_LETTERS = "sendAgencyMcbLetters";
    public static final String SEND_AGENCY_DIRECT_LETTERS = "sendAgencyDirectLetters";
    public static final String IS_GOOD_USER = "isGoodUser";
    public static final String CLIENT_ID = "clientID";
    public static final String USER_ID = "userID";
    public static final String CITY_ID = "cityID";
    public static final String ALLOW_MERGING_CLIENT_IDS = "allowMergingClientIDs";
    public static final String AGENCY_LOGIN = "agencyLogin";
    public static final String DISPLAY_STORE_RATING = "displayStoreRating";

    public ClientInfoMap(String packageName) {
        super(packageName, CLIENT_INFO);
    }

    public static final String DEFAULT_PHONE = "+7(812)123-45-67";

    public ClientInfoMap(T clientInfo) {
        super();
        setBean(clientInfo);
    }

    public ClientInfoMap defaultClientInfo() {
        this.put(FIO, "Автотест Иванович");
        this.put(EMAIL, "at-tester1@yandex-team.ru");
        this.put(PHONE, DEFAULT_PHONE);
        this.put(SEND_NEWS, Value.NO);
        this.put(SEND_ACC_NEWS, Value.YES);
        this.put(SEND_WARN, Value.YES);
        return this;
    }

    public ClientInfoMap anotherClientInfo() {
        this.put(FIO, "Автотест Петрович");
        this.put(EMAIL, "at-tester2@yandex-team.ru");
        this.put(PHONE, "8 812 7654321");
        this.put(SEND_NEWS, Value.YES);
        this.put(SEND_ACC_NEWS, Value.NO);
        this.put(SEND_WARN, Value.NO);
        return this;
    }

    public ClientInfoMap defaultAgencyInfo() {
        this.put(FIO, "Агентство Агентов профиля Clients");
        this.put(EMAIL, "at-tester1@yandex-team.ru");
        this.put(PHONE, DEFAULT_PHONE);
        this.put(SEND_NEWS, Value.YES);
        this.put(SEND_ACC_NEWS, Value.NO);
        this.put(SEND_WARN, Value.YES);
        return this;
    }

    public ClientInfoMap anotherAgencyInfo() {
        this.put(FIO, "Агенты Агентства профиля Clients");
        this.put(EMAIL, "at-tester2@yandex-team.ru");
        this.put(PHONE, "7654321");
        this.put(SEND_NEWS, Value.NO);
        this.put(SEND_ACC_NEWS, Value.YES);
        this.put(SEND_WARN, Value.NO);
        return this;
    }

    public ClientInfoMap withEmail(String email) {
        this.put((EMAIL), email);
        return this;
    }


    public static String normilizeLogin(String login) {
        return login.replaceAll("\\.", "-");
    }

    public ClientInfoMap withClientRights(ClientRightMap... clientRightMap) {
        if (clientRightMap != null) {
            this.put(CLIENT_RIGHTS, convert(clientRightMap, new BeanMapToBeanConverter<>())
                    .toArray((Object[]) Array.newInstance(new ClientRightMap<>(super.getPackageName())
                            .getBean().getClass(), 0)));
        } else {
            this.put(CLIENT_RIGHTS, null);
        }
        return this;
    }

    public ClientInfoMap withPhone(String phone) {
        this.put(PHONE, phone);
        return this;
    }

    public ClientInfoMap withAgencyName(String agencyName) {
        this.put(AGENCY_NAME, agencyName);
        return this;
    }

    public ClientInfoMap withAgencyStatus(String status) {
        this.put(AGENCY_STATUS, status);
        return this;
    }

    public ClientInfoMap withAgencyUrl(String url) {
        this.put(AGENCY_URL, url);
        return this;
    }

    public ClientInfoMap withAllowMergingClientIDs(String value) {
        this.put(ALLOW_MERGING_CLIENT_IDS, value);
        return this;
    }

    public ClientInfoMap withCityId(String cityId) {
        this.put(CITY_ID, cityId);
        return this;
    }

    public ClientInfoMap withClientCurrencies(String... clientCurrencies) {
        this.put(CLIENT_CURRENCIES, clientCurrencies);
        return this;
    }

    public ClientInfoMap withVATRate(Float vatRate) {
        this.put(VATRATE, vatRate);
        return this;
    }

    public ClientInfoMap withClientID(int clientID) {
        this.put(CLIENT_ID, clientID);
        return this;
    }

    public ClientInfoMap withCurrency(String currency) {
        this.put(CURRENCY, currency);
        return this;
    }

    public ClientInfoMap withLogin(String login) {
        this.put(LOGIN, login);
        return this;
    }

    public ClientInfoMap withFIO(String fio) {
        this.put(FIO, fio);
        return this;
    }

    public ClientInfoMap withSendNews(String value) {
        this.put(SEND_NEWS, value);
        return this;
    }

    public ClientInfoMap withSendAccNews(String value) {
        this.put(SEND_ACC_NEWS, value);
        return this;
    }

    public ClientInfoMap withSendWarn(String value) {
        this.put(SEND_WARN, value);
        return this;
    }

    public ClientInfoMap withDisplayStoreRating(String value) {
        this.put(DISPLAY_STORE_RATING, value);
        return this;
    }

    public ClientInfoMap withOverdraftSumAvailable(Float value) {
        this.put(OVERDRAFT_SUM_AVAILABLE, value);
        return this;
    }

    public ClientInfoMap withOverdraftSumAvailableInCurrency(Float value) {
        this.put(OVERDRAFT_SUM_AVAILABLE_IN_CURRENCY, value);
        return this;
    }

    /**
     * Return array of ClientRightMap for not null values
     *
     * @param allowEditValue
     * @param allowImportValue
     * @return
     */
    public ClientInfoMap withClientRights(
            String allowEditValue, String allowImportValue, String allowTransferValue)
    {
        List<ClientRightMap> list = new ArrayList<>();
        if (allowEditValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowEditCampaign(allowEditValue));
        }
        if (allowImportValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowImportXls(allowImportValue));
        }
        if (allowTransferValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowTransferMoney(allowTransferValue));
        }
        withClientRights(list.toArray(new ClientRightMap[list.size()]));
        return this;
    }

    public ClientInfoMap withClientRights(
            String agencyLogin, String allowEditValue, String allowImportValue, String allowTransferValue)
    {
        List<ClientRightMap> list = new ArrayList<>();
        if (allowEditValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowEditCampaign(allowEditValue).withAgencyLogin(agencyLogin));
        }
        if (allowImportValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowImportXls(allowImportValue).withAgencyLogin(agencyLogin));
        }
        if (allowTransferValue != null) {
            list.add(new ClientRightMap(getPackageName())
                    .allowTransferMoney(allowTransferValue).withAgencyLogin(agencyLogin));
        }
        withClientRights(list.toArray(new ClientRightMap[list.size()]));
        return this;
    }
}
