package ru.yandex.autotests.directapi.model.clients;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created with IntelliJ IDEA.
 * User: omaz
 * Date: 06.09.13
 * Time: 15:14
 * To change this template use File | Settings | File Templates.
 */
public class ClientRightMap<T> extends ModelBeanMap<ClientRightMap> {
    private static final String CLIENT_RIGHT = "ClientRight";

    public static final String RIGHT_NAME = "rightName";
    public static final String VALUE = "value";
    public static final String AGENCY_NAME = "agencyName";
    private static final String AGENCY_LOGIN = "agencyLogin";

    public ClientRightMap(String packageName) {
        super(packageName, CLIENT_RIGHT);
    }


    public ClientRightMap(T clientInfo) {
        super();
        setBean(clientInfo);
    }

    public ClientRightMap withRightName(String rightName) {
        this.put(RIGHT_NAME, rightName);
        return this;
    }

    public ClientRightMap withRightValue(String value) {
        this.put(VALUE, value);
        return this;
    }

    public ClientRightMap allowEditCampaign(String value) {
        this.withRightName(RightName.ALLOW_EDIT_CAMPAIGNS);
        this.put(VALUE, value);
        return this;
    }

    public ClientRightMap allowImportXls(String value) {
        this.withRightName(RightName.ALLOW_IMPORT_XLS);
        this.put(VALUE, value);
        return this;
    }

    public ClientRightMap allowTransferMoney(String value) {
        this.withRightName(RightName.ALLOW_TRANSFER_MONEY);
        this.put(VALUE, value);
        return this;
    }

    public ClientRightMap withAgencyLogin(String agencyLogin) {
        this.put(AGENCY_LOGIN, agencyLogin);
        return this;
    }
}
