package ru.yandex.autotests.directapi.model.clients;

import org.apache.commons.lang.RandomStringUtils;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.model.common.Value;


/**
 * Created with IntelliJ IDEA.
 * User: omaz
 * Date: 06.09.13
 * Time: 11:47
 * To change this template use File | Settings | File Templates.
 */
public class CreateNewSubclientRequestMap<T> extends ModelBeanMap<CreateNewSubclientRequestMap> {
    private static final String CREATE_NEW_SUBCLIENT_REQUEST = "CreateNewSubclientRequest";

    public static final String LOGIN = "login";
    public static final String AGENCY_LOGIN = "agencyLogin";
    public static final String NAME = "name";
    public static final String SURNAME = "surname";
    public static final String CURRENCY = "currency";
    public static final String SERVICED_CLIENT = "servicedClient";
    public static final String LOGIN_EXISTS = "loginExists";


    public CreateNewSubclientRequestMap(String packageName) {
        super(packageName, CREATE_NEW_SUBCLIENT_REQUEST);
        this.put((NAME), "Василий");
        this.put((SURNAME), "Петрович");
    }

    //region Builder

    public CreateNewSubclientRequestMap defaultSubclient(String base, String agencyLogin) {
        this.put((LOGIN), base + RandomStringUtils.randomAlphabetic(5));
        this.put((AGENCY_LOGIN), agencyLogin);
        this.put((NAME), "Василий");
        this.put((SURNAME), "Петрович");
        return this;
    }

    public CreateNewSubclientRequestMap defaultServicedSubclient(String base) {
        this.put((LOGIN), base + RandomStringUtils.randomAlphabetic(5));
        this.put((NAME), "Василий");
        this.put((SURNAME), "Петрович");
        this.put((SERVICED_CLIENT), Value.YES);
        return this;
    }

    public CreateNewSubclientRequestMap withLogin(String login) {
        this.put((LOGIN), login);
        return this;
    }

    public CreateNewSubclientRequestMap withRandomLogin(String login) {
        this.put((LOGIN), login + RandomStringUtils.randomAlphabetic(7).toLowerCase());
        return this;
    }

    public CreateNewSubclientRequestMap withAgencyLogin(String agencyLogin) {
        this.put((AGENCY_LOGIN), agencyLogin);
        return this;
    }

    public CreateNewSubclientRequestMap withLoginExists(boolean loginExists) {
        this.put((LOGIN_EXISTS), loginExists ? Value.YES : Value.NO);
        return this;
    }

    public CreateNewSubclientRequestMap withServicedClient(String yesNoValue) {
        this.put((SERVICED_CLIENT), yesNoValue);
        return this;
    }

    public CreateNewSubclientRequestMap withCurrency(Currency currency) {
        if (currency != null) {
            this.put((CURRENCY), currency.name());
        }
        return this;
    }

    public CreateNewSubclientRequestMap withCurrency(String currency) {
        if (currency != null) {
            this.put((CURRENCY), currency);
        }
        return this;
    }

    public CreateNewSubclientRequestMap withName(String name) {
        this.put((NAME), name);
        return this;
    }

    public CreateNewSubclientRequestMap withSurname(String surname) {
        this.put((SURNAME), surname);
        return this;
    }
    //endregion
}
