package ru.yandex.autotests.directapi.model.clients;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created with IntelliJ IDEA.
 * User: omaz
 * Date: 06.09.13
 * Time: 11:47
 * To change this template use File | Settings | File Templates.
 */
public class GetSubClientsRequestMap<T> extends ModelBeanMap<GetSubClientsRequestMap> {
    private static final String GET_SUB_CLIENTS_REQUEST = "GetSubClientsRequest";

    public static final String LOGIN = "login";
    public static final String FILTER = "filter";


    public GetSubClientsRequestMap(String packageName) {
        super(packageName, GET_SUB_CLIENTS_REQUEST);
    }

    //region Builder

    public GetSubClientsRequestMap withLogin(String login) {
        this.put((LOGIN), login);
        return this;
    }

    public GetSubClientsRequestMap withFilter(ClientFilterMap clientFilterMap) {
        this.put(FILTER, clientFilterMap.getBean());
        return this;
    }

    //endregion
}
