package ru.yandex.autotests.directapi.model.clients;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by mariabye on 31.01.14.
 */
public class SearchClientsRequestMap<T> extends ModelBeanMap<SearchClientsRequestMap> {
    private static final String SEARCH_CLIENTS_REQUEST = "SearchClientsRequest";

    public static final String USER_ID = "userID";
    public static final String CLIENT_ID = "clientID";
    public static final String CAMPAIGN_ID = "campaignID";
    public static final String NAME = "name";
    public static final String LOGIN = "login";
    public static final String MANAGER_LOGINS = "managerLogins";

    public SearchClientsRequestMap(String type) {
        super(type, SEARCH_CLIENTS_REQUEST);
    }

    public SearchClientsRequestMap(T searchClientsRequest) {
        super();
        setBean(searchClientsRequest);
    }

    public SearchClientsRequestMap withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public SearchClientsRequestMap withUserID(int userID) {
        put(USER_ID, userID);
        return this;
    }

    public SearchClientsRequestMap withClientID(int clientID) {
        put(CLIENT_ID, clientID);
        return this;
    }

    public SearchClientsRequestMap withCampaignID(int campaignID) {
        put(CAMPAIGN_ID, campaignID);
        return this;
    }

    public SearchClientsRequestMap withName(String name) {
        put(NAME, name);
        return this;
    }

    public SearchClientsRequestMap withManagerLogins(String... managerLogins) {
        put(MANAGER_LOGINS, managerLogins);
        return this;
    }
}
