package ru.yandex.autotests.directapi.model.finances;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 22.09.15.
 */
public class CheckPaymentInfoMap<T> extends ModelBeanMap<CheckPaymentInfoMap> {

    private static final String CHECK_PAYMENT_INFO = "CheckPaymentInfo";

    public static final String CUSTOM_TRANSACTION_ID = "customTransactionID";

    public CheckPaymentInfoMap(String packageName) {
        super(packageName, CHECK_PAYMENT_INFO);
    }

    public CheckPaymentInfoMap(T checkPaymentInfo) {
        super();
        setBean(checkPaymentInfo);
    }

    public CheckPaymentInfoMap withCustomTransactionId(String customTransactionId) {
        this.put(CUSTOM_TRANSACTION_ID, customTransactionId);
        return this;
    }
}
