package ru.yandex.autotests.directapi.model.finances;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 26.12.13
 * Time: 11:00
 * To change this template use File | Settings | File Templates.
 */
public class CreateInvoiceInfoMap<T> extends ModelBeanMap<CreateInvoiceInfoMap> {

    private static final String CREATE_INVOICE_INFO = "CreateInvoiceInfo";
    public static final String PAYMENTS = "payments";

    public CreateInvoiceInfoMap(String packageName) {
        super(packageName, CREATE_INVOICE_INFO);
    }

    public CreateInvoiceInfoMap(T createInvoiceInfo) {
        super();
        setBean(createInvoiceInfo);
    }

    public CreateInvoiceInfoMap withPayments(PayCampElementMap... payCampElements) {
        this.put((PAYMENTS), null);
        if (payCampElements != null) {
            this.put((PAYMENTS),
                    convert(payCampElements, new BeanMapToBeanConverter())
                            .toArray(new PayCampElementMap(super.getPackageName()).emptyBeanArray()));

        }
        return this;
    }
}
